/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import oracle.aurora.util.BufferedOutputStream;

public class SocketConnection {
    protected Socket socket;
    protected BufferedInputStream instream;
    protected BufferedOutputStream outstream;
    protected static Hashtable defaultPorts;
    static int nOpen;

    public static int getDefaultPort(String protocol) {
        Integer ip = (Integer)defaultPorts.get(protocol);
        return ip == null ? -1 : ip;
    }

    public static void addDefaultPort(String protocol, int port) {
        defaultPorts.put(protocol, new Integer(port));
    }

    public SocketConnection(URL url, int timeout) throws IOException {
        int port = url.getPort();
        if (port == -1 && (port = SocketConnection.getDefaultPort(url.getProtocol())) == -1) {
            throw new IOException("No port or default given for protocol: " + url.getProtocol());
        }
        this.init(new Socket(url.getHost(), port), timeout);
    }

    public SocketConnection(Socket s, int timeout) throws IOException {
        this.init(s, timeout);
    }

    protected void init(Socket s, int timeout) throws IOException {
        ++nOpen;
        this.socket = s;
        if (timeout != -1) {
            this.socket.setSoTimeout(timeout);
        }
        this.instream = new BufferedInputStream(this.socket.getInputStream());
        this.outstream = new BufferedOutputStream(this.socket.getOutputStream());
    }

    public InputStream getInputStream() {
        return this.instream;
    }

    public OutputStream getOutputStream() {
        return this.outstream;
    }

    public void flush() throws IOException {
        this.outstream.flush();
    }

    public static int nOpenSockets() {
        return nOpen;
    }

    public void close() throws IOException {
        this.flush();
        this.socket.close();
        this.instream = null;
        this.outstream = null;
        --nOpen;
    }

    public Socket getSocket() {
        return this.socket;
    }

    static {
        nOpen = 0;
        defaultPorts = new Hashtable();
        SocketConnection.addDefaultPort("http", 80);
    }
}

