/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.aurora.server.tools.loadjava.ByteCode;
import oracle.aurora.server.tools.loadjava.ByteCodeReader;
import oracle.aurora.server.tools.loadjava.ClassifyFiles;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.GenMissingOptions;
import oracle.aurora.server.tools.loadjava.LoadJavaLog;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.util.IOCopy;
import oracle.aurora.util.classfile.ClassFile;
import oracle.aurora.util.classfile.ClassPath;
import oracle.aurora.util.classfile.Descriptor;
import oracle.aurora.util.classfile.Dig;
import oracle.aurora.util.classfile.Raw;
import oracle.aurora.util.classfile.RawFactory;
import oracle.aurora.util.msg.Msg;
import oracle.aurora.util.tools.ToolException;

public class GenMissing
implements Raw.JavaConstants {
    private Msg mkMsg = MkMsg.mkMsg;
    static final byte[] version = new byte[]{0};
    public static final int opc_invokestatic = 184;
    static String genMissingAttributeName = "aurora.genmissing";
    HashSet existsSet;
    HashSet missingSet;
    HashSet interfacesSet;
    HashMap methodsMap;
    IOCopy ioCopy = new IOCopy();
    LoadJavaState state;
    GenMissingOptions opts;

    GenMissing() {
        this.setOpts(new GenMissingOptions());
        this.init();
    }

    GenMissing(Options options, LoadJavaState state) {
        this.setOpts(options);
        this.state = state;
        this.init();
    }

    LoadJavaState getState() {
        if (this.state == null) {
            this.state = new LoadJavaState(this.getOpts());
        }
        return this.state;
    }

    GenMissingOptions getOpts() {
        if (this.opts == null) {
            this.opts = new GenMissingOptions();
        }
        return this.opts;
    }

    void setLog(LoadJavaLog log) {
        this.getState().setLog(log);
    }

    void setDatabase(DatabaseOptions database) {
        this.getState().setDatabase(database);
    }

    void setOpts(Options opts) {
        this.opts = opts == null ? null : (opts instanceof GenMissingOptions ? (GenMissingOptions)opts : new GenMissingOptions(opts));
    }

    void init() {
        this.existsSet = new HashSet();
        this.missingSet = new HashSet();
        this.interfacesSet = new HashSet();
        this.methodsMap = new HashMap();
    }

    void generateJar() {
        if (this.countMissing() == 0) {
            this.msg(this.mkMsg.m("no missing files"));
        } else {
            String jarName = this.getOpts().getDestination();
            this.msg(this.mkMsg.m("creating: {0}", jarName));
            try {
                OutputStream fOut = this.ioCopy.toBuffered(new FileOutputStream(jarName));
                ZipOutputStream jar = new ZipOutputStream(fOut);
                this.generateAll(jar);
                jar.close();
            }
            catch (IOException ioex) {
                this.err(ioex, this.mkMsg.m("creating jar: {0}", jarName));
            }
        }
    }

    int countMissing() {
        return this.missingSet.size();
    }

    Iterator missing() {
        return this.missingSet.iterator();
    }

    void generateAll(ZipOutputStream jar) {
        Iterator mIt = this.missing();
        while (mIt.hasNext()) {
            this.checkCancelled();
            String name = (String)mIt.next();
            try {
                ZipEntry entry = new ZipEntry(name + ".class");
                jar.putNextEntry(entry);
                this.generate(name, jar);
                jar.closeEntry();
            }
            catch (IOException ioex) {
                this.err(ioex, this.mkMsg.m("generating class {0}", name));
            }
        }
    }

    void addMethod(RawFactory factory, MethodInfo info) {
        Raw.Code codeAttribute;
        String name = info.name;
        String descriptor = info.descriptor;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream d = new DataOutputStream(b);
        Raw.Constant errorClass = factory.constant(7, "java/lang/NoClassDefFoundError");
        Raw.Constant objectClass = factory.constant(7, "java/lang/Object");
        Raw.Constant message = factory.constant(8, "!!!ERROR!!! generated by genmissing");
        Raw.Constant exceptionCtorType = factory.constant(1, "(Ljava/lang/String;)V");
        Raw.Constant objectCtorType = factory.constant(1, "()V");
        Raw.Constant ctorName = factory.constant(1, "<init>");
        Raw.Constant ctor = factory.constant(10, errorClass, factory.constant(12, ctorName, exceptionCtorType));
        Raw.Constant objectCtor = factory.constant(10, objectClass, factory.constant(12, ctorName, objectCtorType));
        if ((info.access & 0x400) != 0) {
            codeAttribute = null;
        } else {
            try {
                if (name.equals("<init>")) {
                    d.writeByte(42);
                    d.writeByte(183);
                    d.writeShort(factory.add(objectCtor));
                }
                d.writeByte(187);
                d.writeShort(factory.add(errorClass));
                d.writeByte(89);
                d.writeByte(19);
                d.writeShort(factory.add(message));
                d.writeByte(183);
                d.writeShort(factory.add(ctor));
                d.writeByte(191);
                d.flush();
            }
            catch (IOException ioex) {
                this.err(ioex, this.mkMsg.m("adding {0} to class", name));
            }
            byte[] byteCodes = b.toByteArray();
            Descriptor xDescriptor = new Descriptor(descriptor);
            int argLen = 2 * xDescriptor.getArgs().length;
            codeAttribute = new Raw.Code(argLen + 4, argLen + 1, byteCodes, null, null);
        }
        factory.addMethod(info.access, name, descriptor, codeAttribute, null);
    }

    void addMethodInfos(Set infos, RawFactory factory, int access) {
        if (infos != null) {
            for (MethodInfo m : infos) {
                m.access |= access;
                this.addMethod(factory, m);
            }
        }
    }

    void addGenMissingAttribute(RawFactory factory) {
        int xName = factory.addConstant(1, genMissingAttributeName);
        factory.add(new Raw.Attribute(xName, version));
    }

    void generate(String name, OutputStream out) {
        try {
            this.msg(this.mkMsg.m("generating: {0}", name));
            RawFactory factory = new RawFactory();
            factory.setThis(name);
            factory.setSuper("java/lang/Object");
            int classAccess = 1;
            int methodAccess = 1;
            if (this.interfacesSet.contains(name)) {
                classAccess |= 0x600;
                methodAccess |= 0x400;
            }
            factory.setAccess(classAccess);
            this.addMethod(factory, new MethodInfo("<clinit>", "()V", 8));
            boolean access = true;
            this.addMethodInfos((Set)this.methodsMap.get(name), factory, methodAccess);
            this.addGenMissingAttribute(factory);
            Raw.Class raw = factory.toRaw();
            DataOutputStream dOut = new DataOutputStream(out);
            raw.output(dOut);
            ++this.getState().ld_genmissing;
        }
        catch (IOException ioex) {
            ++this.getState().errors;
            this.err(ioex, this.mkMsg.m("generating {0}", name));
        }
    }

    void addKnown(String fileName) {
        try {
            InputStreamReader r = new InputStreamReader(this.ioCopy.toBuffered(new FileInputStream(fileName)));
            this.addKnown(r);
        }
        catch (IOException ioex) {
            this.err(ioex, this.mkMsg.m("reading known classes from {0}", fileName));
        }
    }

    void addKnown(Reader in) {
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(in);
            tokenizer.resetSyntax();
            tokenizer.wordChars(0, Integer.MAX_VALUE);
            tokenizer.whitespaceChars(32, 32);
            tokenizer.whitespaceChars(13, 13);
            tokenizer.whitespaceChars(10, 10);
            tokenizer.whitespaceChars(9, 9);
            int type = tokenizer.nextToken();
            while (type != -1) {
                this.noteExists(tokenizer.sval);
                type = tokenizer.nextToken();
            }
        }
        catch (IOException ioex) {
            this.err(ioex, this.mkMsg.m("reading known classes"));
        }
    }

    void addFile(String what) {
        ClassifyFiles classifier = this.getOpts().getClassifier();
        try {
            if (classifier.isClassFile(what)) {
                String name = classifier.transformName(what);
                File file = classifier.mkFile(what);
                InputStream in = this.ioCopy.toBuffered(new FileInputStream(file));
                this.add(name, in);
            } else if (classifier.isJarFile(what)) {
                File file = classifier.mkFile(what);
                FileInputStream in = new FileInputStream(file);
                ZipInputStream zip = new ZipInputStream(in);
                this.add(zip, what);
                zip.close();
            } else {
                this.err(this.mkMsg.m("unrecogized kind of file: {0}", what));
            }
        }
        catch (IOException ioex) {
            this.err(ioex, "processing " + what);
        }
    }

    void add(ZipInputStream jar, String what) {
        ClassifyFiles classifier = this.getOpts().getClassifier();
        try {
            ZipEntry entry = jar.getNextEntry();
            while (entry != null) {
                if (classifier.isClassFile(entry.getName())) {
                    this.add(entry.getName(), jar);
                }
                jar.closeEntry();
                entry = jar.getNextEntry();
            }
        }
        catch (IOException ioex) {
            this.err(ioex, this.mkMsg.m("processing {0}", what));
        }
    }

    void add(String name, InputStream in) {
        this.msg(this.mkMsg.m("genmissing: {0}", name));
        try {
            Dig dig = new Dig(new Raw.Class(in));
            this.add(name, dig.getClazz());
        }
        catch (ToolException tex) {
            this.err(tex, this.mkMsg.m("reading {0}", in.toString()));
        }
        catch (IOException ioex) {
            this.err(ioex, this.mkMsg.m("reading {0}", in.toString()));
        }
    }

    String stripArray(String className) {
        String result;
        if (className == null) {
            result = className;
        } else if (className.length() == 0) {
            result = className;
        } else if (className.charAt(0) != '[') {
            result = className;
        } else {
            int x;
            for (x = 0; x < className.length() && className.charAt(x) == '['; ++x) {
            }
            result = x < className.length() && className.charAt(x) == 'L' ? className.substring(x + 1, className.length() - 1) : null;
        }
        return result;
    }

    void add(String name, Dig.Class digClass) {
        this.noteExists(digClass.getSlashName());
        Dig.ConstantPool pool = digClass.getConstants();
        this.classReference(digClass.getSlashSuperClass());
        block5: for (int xConstant = 1; xConstant < pool.size(); ++xConstant) {
            switch (pool.getConstantType(xConstant)) {
                case 7: {
                    String className = pool.getClass(xConstant);
                    className = this.stripArray(className);
                    this.classReference(className);
                    continue block5;
                }
                case 10: {
                    this.classReference(pool.getDeclaringClass(xConstant));
                    this.methodReference(digClass, pool.getDeclaringClass(xConstant), pool.getNameOfRef(xConstant), pool.getDescriptorOfRef(xConstant), xConstant);
                    continue block5;
                }
                case 11: {
                    this.interfaceReference(pool.getDeclaringClass(xConstant));
                    this.methodReference(digClass, pool.getDeclaringClass(xConstant), pool.getNameOfRef(xConstant), pool.getDescriptorOfRef(xConstant), 0);
                }
            }
        }
        for (int xInterface = 0; xInterface < digClass.getInterfaceCount(); ++xInterface) {
            String iName = digClass.getInterface(xInterface);
            this.interfaceReference(iName);
        }
        Dig.Methods methods = digClass.getMethods();
        for (int xMethod = 0; xMethod < methods.count(); ++xMethod) {
            this.noteDescriptor(methods.get(xMethod).getDescriptor());
        }
        Dig.Fields fields = digClass.getFields();
        for (int xFields = 0; xFields < fields.count(); ++xFields) {
            Descriptor d = new Descriptor(fields.get(xFields).getDescriptor());
            if (!d.getFieldType().isClass()) continue;
            String className = d.getFieldType().name();
            this.classReference(className);
        }
    }

    void interfaceReference(String name) {
        if (name != null) {
            this.classReference(name);
            this.interfacesSet.add(name);
        }
    }

    void classReference(String name) {
        while (name != null && name.length() > 0 && name.charAt(0) == '[') {
            name = name.substring(1);
        }
        if (name != null && !this.existsSet.contains(name) && !this.missingSet.contains(name)) {
            if (this.lookFor(name)) {
                this.noteExists(name);
            } else {
                this.noteMissing(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean lookFor(String name) {
        boolean found = false;
        if (!found) {
            ClassPath cp = this.getOpts().getClassPath();
            ClassFile file = cp.getFile(name + ".class");
            boolean bl = found = file != null && file.exists();
        }
        if (!found && this.getState().databaseSupplied()) {
            Statement shortNameStmt = null;
            Statement selectStmt = null;
            try {
                Connection conn = this.getState().getConnection();
                shortNameStmt = conn.prepareCall("{? = call dbms_java.shortname(?) }");
                shortNameStmt.setString(2, name);
                shortNameStmt.registerOutParameter(1, 12);
                shortNameStmt.execute();
                String shortName = shortNameStmt.getString(1);
                selectStmt = conn.prepareStatement("SELECT object_name FROM all_objects WHERE  OBJECT_TYPE = 'JAVA CLASS' AND  OBJECT_NAME = ? ");
                selectStmt.setString(1, shortName);
                ResultSet r = selectStmt.executeQuery();
                found = r.next();
                r.close();
            }
            catch (SQLException sqlex) {
                this.err(sqlex, this.mkMsg.m("looking for {0}", name));
            }
            finally {
                try {
                    if (shortNameStmt != null) {
                        shortNameStmt.close();
                    }
                    if (selectStmt != null) {
                        selectStmt.close();
                    }
                }
                catch (SQLException ignore) {}
            }
        }
        return found;
    }

    void typeReference(Descriptor.Type type) {
        if (type != null && type.isClass()) {
            this.classReference(type.name());
        }
    }

    void noteDescriptor(String descriptor) {
        Descriptor d = new Descriptor(descriptor);
        if (d.isMethod()) {
            Descriptor.Type[] args = d.getArgs();
            for (int xArg = 0; xArg < args.length; ++xArg) {
                this.typeReference(args[xArg]);
            }
            this.typeReference(d.getReturnType());
        }
    }

    void methodReference(Dig.Class dclass, String className, String methodName, String descriptor, int const_pool_offset) {
        if (!this.existsSet.contains(className)) {
            int is_static = 0;
            Raw.Class rclass = dclass.getRaw();
            int count = rclass.methodCount;
            HashSet<MethodInfo> classMethods = (HashSet<MethodInfo>)this.methodsMap.get(className);
            if (classMethods == null) {
                classMethods = new HashSet<MethodInfo>();
                this.methodsMap.put(className, classMethods);
            }
            for (int i = 0; i < count; ++i) {
                Raw.Member rmeth = rclass.methods[i];
                Dig.Methods meths = dclass.getMethods();
                Dig.Member digm = meths.get(i);
                Dig.Attribute attr = digm.getAttributes().get("Code");
                if (attr == null) continue;
                Dig.Code code = dclass.makeCode(attr);
                byte[] bcodes = code.getBytecodes();
                ByteCode currbc = new ByteCode();
                ByteCodeReader bcr = new ByteCodeReader(bcodes, 0);
                while (bcr.hasNext()) {
                    bcr.readNextByteCode(currbc);
                    int opcode = currbc.getOpcode();
                    switch (opcode) {
                        case 184: {
                            if (currbc.getArgsAsCPIndex() != const_pool_offset) break;
                            is_static = 8;
                        }
                    }
                }
            }
            MethodInfo m = new MethodInfo(methodName, descriptor, is_static);
            classMethods.add(m);
            this.noteDescriptor(descriptor);
        }
    }

    void noteExists(String className) {
        this.existsSet.add(className);
        this.missingSet.remove(className);
        this.methodsMap.remove(className);
    }

    void noteMissing(String className) {
        this.missingSet.add(className);
    }

    LoadJavaLog getLog() {
        return this.getState().getLog();
    }

    void err(Exception ex, String when) {
        this.getLog().err(ex, when);
    }

    void err(String what) {
        this.getLog().err(what);
    }

    void warn(Exception ex, String when) {
        this.getLog().warn(ex, when);
    }

    void warn(String what) {
        this.getLog().warn(what);
    }

    void msg(String what) {
        this.getLog().msg(what);
    }

    boolean printMissingList(PrintWriter pw) {
        Iterator mc = this.missing();
        while (mc.hasNext()) {
            String cl = (String)mc.next();
            pw.print(cl);
            pw.println();
        }
        return !pw.checkError();
    }

    void writeOutFile(String file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (IOException ioe) {
            System.out.println("could not open file " + file);
            return;
        }
        if (!this.printMissingList(new PrintWriter(fos))) {
            System.err.println("An error occured while writing " + file);
        }
    }

    void command(String[] argv) throws ToolsException {
        try {
            Options.Args args = new Options.Args(argv);
            this.getState().parseArgs(args);
            if (this.getOpts() != this.getState().getOpts()) {
                this.getOpts().parseArgs(args);
            }
            this.init();
            String k = this.getOpts().getString("-knownfile");
            if (k != null) {
                this.addKnown(k);
            }
            String[] files = args.unused();
            for (int x = 0; x < files.length; ++x) {
                this.checkCancelled();
                this.addFile(files[x]);
            }
            String o = this.getOpts().getString("-outfile");
            if (o != null) {
                this.writeOutFile(o);
            }
            if (this.getOpts().getBoolean("-destination")) {
                this.generateJar();
            }
            if (!this.getOpts().getBoolean("-silent")) {
                this.printMissingList(new PrintWriter(System.out));
            }
        }
        catch (ToolsError tex) {
            throw new ToolsException(tex.getMessage(), tex);
        }
    }

    public void cancel(String msg) {
        this.getState().setCancelled(msg);
    }

    void checkCancelled() {
        this.getState().checkCancelled();
    }

    void preLoadGenMissing(Vector files) {
        ClassifyFiles classifier = this.getOpts().getClassifier();
        Enumeration fileNames = files.elements();
        while (fileNames.hasMoreElements()) {
            String name = (String)fileNames.nextElement();
            try {
                FileInputStream in = new FileInputStream(name);
                if (classifier.isClassFile(name)) {
                    Dig dig = new Dig(new Raw.Class(in));
                    this.noteExists(dig.getClazz().getSlashName());
                    in.close();
                    continue;
                }
                if (!classifier.isJarFile(name)) continue;
                ZipInputStream zip = new ZipInputStream(in);
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    if (classifier.isClassFile(entry.getName())) {
                        Dig dig = new Dig(new Raw.Class(zip));
                        this.noteExists(dig.getClazz().getSlashName());
                    }
                    zip.closeEntry();
                    entry = zip.getNextEntry();
                }
                in.close();
            }
            catch (IOException ioex) {
                this.err(ioex, this.mkMsg.m("processing {0}", name));
            }
            catch (ToolException ioex) {
                this.err(ioex, this.mkMsg.m("processing {0}", name));
            }
        }
    }

    public static void main(String[] argv) {
        GenMissing g = new GenMissing();
        try {
            g.command(argv);
        }
        catch (ToolsException ex) {
            System.err.println("exiting  : " + ex.getMessage());
            if (ex.getChain() != null) {
                System.err.println("exiting reason:  " + ex.getChain());
            }
            System.exit(1);
        }
        catch (ToolsError ex) {
            System.err.println("exiting   " + ex.getMessage());
            System.exit(1);
        }
    }

    static class MethodInfo {
        int access;
        String name;
        String descriptor;

        MethodInfo(String name, String descriptor, int access) {
            this.name = name;
            this.descriptor = descriptor;
            this.access = access;
        }

        MethodInfo(String name, String descriptor) {
            this(name, descriptor, 1);
        }

        public int hashCode() {
            return this.name.hashCode() + this.descriptor.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof MethodInfo && this.name.equals(((MethodInfo)other).name) && this.descriptor.equals(((MethodInfo)other).descriptor) && this.access == ((MethodInfo)other).access;
        }

        public String toString() {
            return "<" + this.name + "," + this.descriptor + ", " + Integer.toHexString(this.access) + ">";
        }
    }
}

