/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.rdbms.security.PolicyTableRow;
import oracle.aurora.rdbms.security.PolicyTableRows;

class PolicyTableQuery {
    String stmtString;
    PolicyTable table;
    String where;
    PolicyTableRow row;
    int flags;

    PolicyTableQuery(PolicyTable table, String where, PolicyTableRow row, int flags) {
        this.table = table;
        this.where = where;
        this.row = row;
        this.flags = flags;
    }

    boolean exists() {
        PolicyTableRows it = this.rows();
        boolean hasOne = it.hasNext();
        it.close();
        return hasOne;
    }

    PolicyTableRows rows() {
        PreparedStatement s = this.statement();
        if (this.row != null) {
            this.setQuery(s);
        }
        return new PolicyTableRows(this, s, this.statementString());
    }

    PreparedStatement statement() {
        String s = this.statementString();
        PreparedStatement stmt = null;
        try {
            stmt = this.table.connection().prepareStatement(s);
        }
        catch (SQLException ex) {
            this.table.noteError(ex);
            try {
                stmt = this.table.connection().prepareStatement("select * from dual where 1 = 0 ");
            }
            catch (SQLException ex1) {
                throw new Error("could not create any PreparedStatement");
            }
        }
        return stmt;
    }

    String statementString() {
        if (this.stmtString == null) {
            this.stmtString = "select kind#, grantee#, type_schema#, type_name, name, action, status#, key from " + this.table.getTableName() + " where " + this.where;
        }
        return this.stmtString;
    }

    void setQuery(PreparedStatement stmt) {
        int y = 1;
        for (int x = 1; x <= 8; ++x) {
            if ((this.flags & 1 << x) == 0) continue;
            try {
                if (PolicyTable.isInt[x]) {
                    stmt.setLong(y++, this.row.getLong(x));
                    continue;
                }
                if (this.row.getString(x) == null) continue;
                stmt.setString(y++, this.row.getString(x));
                continue;
            }
            catch (SQLException ex) {
                System.out.println("columnName[" + x + "] = " + PolicyTable.columnNames[x]);
                System.out.println("paramIdx = " + y);
                this.table.noteError(ex);
                throw new Error("columnName[" + x + "] = " + PolicyTable.columnNames[x] + " paramIdx = " + y, ex);
            }
        }
    }
}

