/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.genmsg;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import oracle.aurora.genmsg.GenMsgOptions;
import oracle.aurora.genmsg.GenMsgParser;
import oracle.aurora.genmsg.Generate;
import oracle.aurora.genmsg.ParseException;
import oracle.aurora.util.tools.Options;

public class GenMsg {
    Vector files;
    TreeMap allKeys = new TreeMap();
    GenMsgOptions opts;

    GenMsg() {
    }

    void run() {
        for (String fileName : this.files) {
            try {
                GenMsgParser parser = GenMsgParser.run(fileName, new FileReader(fileName));
                this.addKeys(parser.ctx.getMap());
            }
            catch (FileNotFoundException ex) {
                System.err.println("Could not open file " + fileName);
            }
            catch (ParseException ex) {
                System.err.println("Parsing " + fileName + " failed ");
                System.err.println("     " + ex.toString());
            }
        }
        Generate g = new Generate(this.opts);
        OutputStream out = System.out;
        if (this.opts.getString("-outfile") != null) {
            try {
                out = new FileOutputStream(this.opts.getString("-outFile"));
            }
            catch (FileNotFoundException ex) {
                System.err.println("Could not open " + this.opts.getString("-outFile") + " for output");
                System.err.println("    " + ex);
            }
        }
        try {
            g.generate(this.allKeys, out);
        }
        catch (IOException ioex) {
            System.err.println("Exception while generating Messages.java");
            System.err.println("    " + ioex);
        }
    }

    void addKeys(Map newKeys) {
        this.allKeys.putAll(newKeys);
    }

    void parseArgs(String[] argv) {
        Options.Args args = new Options.Args(argv);
        this.opts = new GenMsgOptions();
        this.opts.parseArgs(args);
        this.files = new Vector();
        for (int xArg = 0; xArg < args.length(); ++xArg) {
            if (args.isUsed(xArg)) continue;
            this.files.add(args.get(xArg));
        }
    }

    void generate(Map keys, OutputStream out) {
        PrintStream pOut = new PrintStream(out);
        pOut.println("allKeys: " + keys);
    }

    public static void main(String[] argv) {
        GenMsg g = new GenMsg();
        g.parseArgs(argv);
        g.run();
    }
}

