/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.M2NIterator;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PBuilder;
import oracle.dbtools.common.x3p.impl.DontResolveExternals;
import oracle.dbtools.common.x3p.impl.Event;
import oracle.dbtools.common.x3p.impl.ForceXMLInputFactory;
import oracle.dbtools.common.x3p.impl.X3PParseException;

public class StAXEventIterator
extends M2NIterator<XMLEvent, Event> {
    StAXEventIterator(Source s) {
        super(StAXEventIterator.read(s));
    }

    @Override
    protected void process(XMLEvent e) {
        e.getEventType();
        if (e.isStartDocument()) {
            this.add(Event.startDocument());
        } else if (e.isEndDocument()) {
            this.add(Event.endDocument());
        } else if (e.isProcessingInstruction()) {
            ProcessingInstruction pi = (ProcessingInstruction)e;
            this.add(Event.processingInstruction(pi.getTarget(), pi.getData()));
        } else if (e.isCharacters()) {
            Characters cs = e.asCharacters();
            if (!cs.isIgnorableWhiteSpace()) {
                char[] chars = cs.getData().toCharArray();
                this.add(Event.characters(chars, 0, chars.length));
            }
        } else if (e.isStartElement()) {
            StartElement se = e.asStartElement();
            Iterator<Namespace> ns = se.getNamespaces();
            while (ns.hasNext()) {
                Namespace n = ns.next();
                this.add(Event.startPrefixMapping(n.getPrefix(), n.getNamespaceURI()));
            }
            this.add(Event.startElement(se.getName(), this.adapt(se.getAttributes())));
        } else if (e.isEndElement()) {
            EndElement ee = e.asEndElement();
            Iterator<Namespace> ns = ee.getNamespaces();
            while (ns.hasNext()) {
                Namespace n = ns.next();
                this.add(Event.endPrefixMapping(n.getPrefix()));
            }
            this.add(Event.endElement(ee.getName()));
        }
    }

    private X3PAttributes adapt(Iterator<Attribute> attributes) {
        X3PBuilder.AttributeBuilder b = X3PBuilder.attributes();
        while (attributes.hasNext()) {
            Attribute a = attributes.next();
            QName name = a.getName();
            String value = a.getValue();
            b.attribute(name, value);
        }
        return b.build();
    }

    private static Iterator<XMLEvent> read(Source s) {
        try {
            XMLInputFactory inputFactory = ForceXMLInputFactory.newInstance();
            inputFactory.setXMLResolver(DontResolveExternals.INSTANCE);
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            return new XMLEventIterator(inputFactory.createXMLEventReader(s));
        }
        catch (XMLStreamException e) {
            throw StAXEventIterator.wrap(e);
        }
        catch (FactoryConfigurationError e) {
            throw StAXEventIterator.wrap(e);
        }
    }

    private static RuntimeException wrap(Throwable t) {
        return new X3PParseException(new TranslatableMessage(t.getMessage()), t);
    }

    private static class XMLEventIterator
    extends AbstractIterator<XMLEvent>
    implements Closeable {
        private boolean empty = false;
        private final XMLEventReader r;

        XMLEventIterator(XMLEventReader r) {
            this.r = r;
        }

        @Override
        protected XMLEvent advance() {
            XMLEvent event = null;
            if (!this.empty && this.r.hasNext()) {
                try {
                    event = this.r.nextEvent();
                }
                catch (XMLStreamException e) {
                    Location l = e.getLocation();
                    if (l.getLineNumber() == 1 && l.getColumnNumber() == 1 && e.getMessage().indexOf("Premature end of file") != -1) {
                        this.empty = true;
                        event = null;
                    }
                    throw StAXEventIterator.wrap(e);
                }
            }
            return event;
        }

        @Override
        public void close() throws IOException {
            try {
                this.r.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }
}

