/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.transform.stream.StreamResult;

final class NewlineNormalizer {
    private NewlineNormalizer() {
    }

    static StreamResult normalize(StreamResult target) {
        Writer w = target.getWriter();
        if (w == null) {
            w = new OutputStreamWriter(target.getOutputStream());
        }
        StreamResult result = new StreamResult(NewlineNormalizer.normalize(w));
        return result;
    }

    static Writer normalize(Writer w) {
        return new NewlineNormalizerWriter(w);
    }

    private static class NewlineNormalizerWriter
    extends FilterWriter {
        private static final char VERBOTTEN = '\r';

        protected NewlineNormalizerWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int x = this.slashR(cbuf, off, len);
            if (x < 0) {
                super.write(cbuf, off, len);
            } else {
                super.write(cbuf, off, x);
                this.write(cbuf, x + 1, len - (x + 1));
            }
        }

        @Override
        public void write(int c) throws IOException {
            if (13 != c) {
                super.write(c);
            }
        }

        @Override
        public void write(String str) throws IOException {
            if (str.length() == 1) {
                this.write(str.charAt(0));
            } else {
                super.write(str);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }

        private int slashR(char[] cbuf, int off, int len) {
            for (int i = 0; i < len; ++i) {
                if ('\r' != cbuf[off + i]) continue;
                return i;
            }
            return -1;
        }
    }
}

