/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p;

import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.common.x3p.X3PSelector;

public class X3PElement
implements X3PSelector {
    private final X3PAttributes attrs;
    private final X3PPath path;

    public X3PElement(X3PPath path, X3PAttributes attrs) {
        this.path = path;
        this.attrs = attrs;
    }

    @Override
    public Boolean apply(X3PSelector x) {
        return (Boolean)Selectors.and(this.path, this.attrs).apply(x);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X3PElement other = (X3PElement)obj;
        if (this.attrs == null ? other.attrs != null : !this.attrs.equals(other.attrs)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public X3PAttributes getAttrs() {
        return this.attrs;
    }

    public X3PPath getPath() {
        return this.path;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attrs == null ? 0 : this.attrs.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("X3PElement [");
        if (this.attrs != null) {
            builder.append("attrs=");
            builder.append(this.attrs);
            builder.append(", ");
        }
        if (this.path != null) {
            builder.append("path=");
            builder.append(this.path);
        }
        builder.append("]");
        return builder.toString();
    }
}

