/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.servlet.ServletResponse;

public abstract class Text {
    private static final String COMMA_DELIMITED = "\\s*,\\s*";
    private static final String DEFAULT = "UTF-8";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String[] EMPTY = new String[0];
    private static final String SPACE_DELIMITED = "\\s+";
    private static final String[] TEXT_MIME_TYPES = new String[]{"text/.*", "application/.*+xml"};

    private Text() {
    }

    public static String[] commaDelimited(String text) {
        String delimiter = COMMA_DELIMITED;
        return Text.delimited(text, COMMA_DELIMITED);
    }

    public static final Charset defaultCharset() {
        return DEFAULT_CHARSET;
    }

    public static final String defaultEncoding() {
        return DEFAULT;
    }

    public static byte[] getBytes(String text) {
        return text.getBytes(DEFAULT_CHARSET);
    }

    public static Reader reader(InputStream in) {
        return new InputStreamReader(in, DEFAULT_CHARSET);
    }

    public static void setCharacterEncoding(ServletResponse res) {
        String contentType = res.getContentType();
        if (Text.isText(contentType)) {
            res.setCharacterEncoding(DEFAULT);
        }
    }

    public static String[] spaceDelimited(String text) {
        return Text.delimited(text, SPACE_DELIMITED);
    }

    public static String toString(byte[] bytes) {
        return new String(bytes, DEFAULT_CHARSET);
    }

    public static Writer writer(OutputStream out) {
        return new OutputStreamWriter(out, DEFAULT_CHARSET);
    }

    public static String stripSuffix(String text, String suffix) {
        if (text.endsWith(suffix)) {
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }

    private static String[] delimited(String text, String delimiter) {
        String[] values = EMPTY;
        if (text != null && (values = text.trim().split(delimiter)).length == 1 && values[0].isEmpty()) {
            values = EMPTY;
        }
        return values;
    }

    private static boolean isText(String contentType) {
        if (contentType != null) {
            for (String type : TEXT_MIME_TYPES) {
                if (!type.matches(contentType)) continue;
                return true;
            }
        }
        return false;
    }
}

