/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Pair;

public abstract class ResourceTracker {
    private static final ThreadLocal<Resources> RESOURCES = new ThreadLocal<Resources>(){

        @Override
        protected Resources initialValue() {
            return new Resources();
        }
    };

    public static void dumpLeaks() throws IOException {
        ResourceTracker.dumpLeaks(System.err);
    }

    public static void dumpLeaks(PrintStream s) throws IOException {
        if (!ResourceTracker.getRESOURCES().isEmpty()) {
            s.println(ResourceTracker.getRESOURCES().size() + " resources not closed in thread: " + Thread.currentThread());
            HashSet<Map.Entry<Object, Resources.Resource>> entries = new HashSet<Map.Entry<Object, Resources.Resource>>(ResourceTracker.getRESOURCES().entrySet());
            for (Map.Entry entry : entries) {
                Object r = entry.getKey();
                s.print("Resource:\n\t");
                try {
                    s.println(r);
                }
                catch (Exception e) {
                    s.println(r.getClass().getName() + "@" + Integer.toHexString(r.hashCode()));
                }
                s.println("Id:\n\t" + ((Resources.Resource)entry.getValue()).first());
                s.println("Created at:\n");
                for (StackTraceElement e : (StackTraceElement[])((Resources.Resource)entry.getValue()).second()) {
                    s.print("\t");
                    s.println(e);
                }
                Closeables.close(r);
            }
        }
    }

    public static long id(Object in) {
        if (in instanceof TrackedResource) {
            return ((TrackedResource)in).id();
        }
        return ResourceTracker.getRESOURCES().id(in);
    }

    public static void release(Object resource) {
        if (resource != null) {
            ResourceTracker.getRESOURCES().remove(resource);
        }
    }

    public static void reset() {
        ResourceTracker.getRESOURCES().clear();
    }

    public static InputStream track(InputStream in) {
        return new TrackedInputStream(in);
    }

    public static void track(Object resource) {
        ResourceTracker.getRESOURCES().put(resource, Thread.currentThread().getStackTrace());
    }

    public static OutputStream track(OutputStream out) {
        return new TrackedOuputStream(out);
    }

    private static Resources getRESOURCES() {
        return RESOURCES.get();
    }

    private static class TrackedOuputStream
    extends FilterOutputStream
    implements TrackedResource {
        TrackedOuputStream(OutputStream out) {
            super(out);
            ResourceTracker.track((Object)out);
        }

        @Override
        public void close() throws IOException {
            ResourceTracker.release(this.out);
            super.close();
        }

        @Override
        public long id() {
            return ResourceTracker.id(this.out);
        }
    }

    private static class TrackedInputStream
    extends FilterInputStream
    implements TrackedResource {
        protected TrackedInputStream(InputStream in) {
            super(in);
            ResourceTracker.track((Object)in);
        }

        @Override
        public void close() throws IOException {
            ResourceTracker.release(this.in);
            super.close();
        }

        @Override
        public long id() {
            return ResourceTracker.id(this.in);
        }
    }

    static final class Resources {
        private long id = 0L;
        private final Map<Object, Resource> resources = new IdentityHashMap<Object, Resource>();

        Resources() {
        }

        public void clear() {
            this.resources.clear();
        }

        public Set<Map.Entry<Object, Resource>> entrySet() {
            return this.resources.entrySet();
        }

        public long id(Object in) {
            Resource r = this.resources.get(in);
            return r == null ? -1L : (Long)r.first();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void remove(Object resource) {
            this.resources.remove(resource);
        }

        public int size() {
            return this.resources.size();
        }

        void put(Object resource, StackTraceElement[] stack) {
            this.resources.put(resource, new Resource(++this.id, stack));
        }

        static final class Resource
        extends Pair<Long, StackTraceElement[]> {
            Resource(long id, StackTraceElement[] stack) {
                super(id, stack);
            }
        }
    }

    public static interface TrackedResource {
        public long id();
    }
}

