/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Transform;

public abstract class MultiAssociativeArrays {
    private MultiAssociativeArrays() {
    }

    public static <K, V> MultiAssociativeArray<K, V> array(AssociativeArray<K, V> values) {
        if (values instanceof MultiAssociativeArray) {
            return (MultiAssociativeArray)values;
        }
        return new FromArray(values);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    private static <K, V> MultiAssociativeArray<K, V> array(K key, V value) {
        return MultiAssociativeArrays.builder().pair(key, value).build();
    }

    private static class Replaced<K, V>
    extends Base<K, V> {
        private final MultiAssociativeArray<K, V> existing;
        private final MultiAssociativeArray<K, V> replaced;

        private Replaced(MultiAssociativeArray<K, V> existing, MultiAssociativeArray<K, V> replaced) {
            this.existing = existing;
            this.replaced = replaced;
        }

        @Override
        public V get(Object key) {
            return Iterables.first(this.values(key));
        }

        @Override
        public Iterator<K> iterator() {
            LinkedHashSet keys = new LinkedHashSet();
            Iterables.add(keys, this.existing);
            Iterables.add(keys, this.replaced);
            return keys.iterator();
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            Iterable<Pair<K, V>> values = this.replaced.values();
            if (NullOrEmpty.nullOrEmpty(values)) {
                return this.existing.values();
            }
            ArrayList<Pair<K, V>> replaced = new ArrayList<Pair<K, V>>();
            for (K key : this) {
                List<V> replacedValues = this.replaced.values(key);
                if (replacedValues == null) {
                    replacedValues = this.existing.values(key);
                }
                for (V value : replacedValues) {
                    replaced.add(Pair.pair(key, value));
                }
            }
            return replaced;
        }

        @Override
        public List<V> values(Object key) {
            List<V> values = this.replaced.values(key);
            if (values != null) {
                return values;
            }
            return this.existing.values(key);
        }
    }

    private static class Removed<K, V>
    extends Base<K, V> {
        private final MultiAssociativeArray<K, V> existing;
        private final MultiAssociativeArray<K, V> removed;

        private Removed(MultiAssociativeArray<K, V> existing, MultiAssociativeArray<K, V> removed) {
            this.existing = existing;
            this.removed = removed;
        }

        @Override
        public V get(Object key) {
            Object value = this.removed.get(key);
            if (value == null) {
                return this.existing.get(key);
            }
            return null;
        }

        @Override
        public Iterator<K> iterator() {
            Iterator<Pair<K, V>> values = this.values().iterator();
            return Iterators.transform(values, new Transform<Pair<K, V>, K>(){

                @Override
                public K apply(Pair<K, V> x) {
                    return x.first();
                }
            });
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            Iterable<Pair<K, V>> values = this.removed.values();
            if (NullOrEmpty.nullOrEmpty(values)) {
                return this.existing.values();
            }
            ArrayList<Pair<K, V>> removed = new ArrayList<Pair<K, V>>();
            Iterables.add(removed, this.existing.values());
            for (Pair<K, V> pair : values) {
                removed.remove(pair);
            }
            return removed;
        }

        @Override
        public List<V> values(Object key) {
            List<V> values = this.removed.values(key);
            if (NullOrEmpty.nullOrEmpty(values)) {
                return this.existing.values(key);
            }
            ArrayList removed = new ArrayList();
            Iterables.add(removed, this.existing.values(key));
            for (Object value : values) {
                removed.remove(value);
            }
            return removed;
        }
    }

    private static class Merged<K, V>
    extends Base<K, V> {
        private final MultiAssociativeArray<K, V> child;
        private final MultiAssociativeArray<K, V> parent;

        private Merged(MultiAssociativeArray<K, V> child, MultiAssociativeArray<K, V> parent) {
            this.child = child;
            this.parent = parent;
        }

        @Override
        public V get(Object key) {
            return Iterables.first(this.values(key));
        }

        @Override
        public Iterator<K> iterator() {
            LinkedHashSet keys = new LinkedHashSet();
            Iterables.add(keys, this.parent);
            Iterables.add(keys, this.child);
            return keys.iterator();
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            LinkedHashSet<Pair<K, V>> values = new LinkedHashSet<Pair<K, V>>();
            Iterables.add(values, this.parent.values());
            Iterables.add(values, this.child.values());
            return values;
        }

        @Override
        public List<V> values(Object key) {
            LinkedHashSet values = new LinkedHashSet();
            Iterables.add(values, this.parent.values(key));
            Iterables.add(values, this.child.values(key));
            return new ArrayList(values);
        }
    }

    private static class FromArray<K, V>
    extends Base<K, V> {
        private final AssociativeArray<K, V> values;

        private FromArray(AssociativeArray<K, V> values) {
            this.values = values;
        }

        @Override
        public V get(Object key) {
            return this.values.get(key);
        }

        @Override
        public Iterator<K> iterator() {
            return this.values.iterator();
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            ArrayList<Pair<K, V>> values = new ArrayList<Pair<K, V>>();
            for (K key : this.values) {
                V value = this.values.get(key);
                values.add(Pair.pair(key, value));
            }
            return values;
        }

        @Override
        public List<V> values(Object key) {
            return Arrays.asList(this.get(key));
        }
    }

    public static class Builder<K, V>
    extends Base<K, V> {
        private final Map<K, List<V>> byKey = new LinkedHashMap<K, List<V>>();
        private final Set<Pair<K, V>> values = new LinkedHashSet<Pair<K, V>>();

        private Builder() {
        }

        public MultiAssociativeArray<K, V> build() {
            return this;
        }

        @Override
        public V get(Object key) {
            return Iterables.first(this.values(key));
        }

        @Override
        public Iterator<K> iterator() {
            return this.byKey.keySet().iterator();
        }

        public Builder<K, V> pair(K key, V value) {
            if (this.values.add(Pair.pair(key, value))) {
                List<V> values = this.byKey.get(key);
                if (values == null) {
                    values = new ArrayList<V>();
                    this.byKey.put(key, values);
                }
                values.add(value);
            }
            return this;
        }

        @Override
        public Iterable<Pair<K, V>> values() {
            return this.values;
        }

        @Override
        public List<V> values(Object key) {
            return this.byKey.get(key);
        }
    }

    public static abstract class Base<K, V>
    extends AssociativeArrays.Base<K, V>
    implements MultiAssociativeArray<K, V> {
        @Override
        public MultiAssociativeArray<K, V> put(AssociativeArray<K, V> values) {
            return new Merged(MultiAssociativeArrays.array(values), this);
        }

        @Override
        public MultiAssociativeArray<K, V> put(K key, V value) {
            return this.put((AssociativeArray)MultiAssociativeArrays.array(key, value));
        }

        @Override
        public MultiAssociativeArray<K, V> remove(K key, V value) {
            return this.remove(MultiAssociativeArrays.array(key, value));
        }

        @Override
        public MultiAssociativeArray<K, V> remove(MultiAssociativeArray<K, V> toRemove) {
            return new Removed(this, toRemove);
        }

        @Override
        public MultiAssociativeArray<K, V> replace(K key, V value) {
            return this.replace(MultiAssociativeArrays.array(key, value));
        }

        @Override
        public MultiAssociativeArray<K, V> replace(MultiAssociativeArray<K, V> toReplace) {
            return new Replaced(this, toReplace);
        }
    }
}

