/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.OrderedMultiMap;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Transform;

public class ListOrderedMultiMap<K, V>
implements OrderedMultiMap<K, V> {
    private final Transform<Pair<K, V>, V> justValue = new Transform<Pair<K, V>, V>(){

        @Override
        public V apply(Pair<K, V> x) {
            return x.second();
        }
    };
    private final List<Pair<K, V>> values = new ArrayList<Pair<K, V>>();

    @Override
    public void add(Iterable<Pair<K, V>> all) {
        for (Pair<K, V> pair : all) {
            this.add(pair.first(), pair.second());
        }
    }

    @Override
    public void add(K key, V value) {
        this.values.add(Pair.pair(key, value));
    }

    @Override
    public Iterable<Pair<K, V>> all() {
        return this.values;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListOrderedMultiMap other = (ListOrderedMultiMap)obj;
        return !(this.values == null ? other.values != null : !((Object)this.values).equals(other.values));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : ((Object)this.values).hashCode());
        return result;
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return null;
    }

    @Override
    public void remove(int i) {
        this.values.remove(i);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public String toString() {
        return this.values.toString();
    }

    @Override
    public V value(K key) {
        Iterator<V> values = this.values(key).iterator();
        if (values.hasNext()) {
            return values.next();
        }
        return null;
    }

    @Override
    public Iterable<V> values(final K key) {
        Selector keyMatches = new Selector<Pair<K, V>>(){

            @Override
            public Boolean apply(Pair<K, V> x) {
                return key.equals(x.first());
            }
        };
        return Iterables.transform(Iterables.select(this.values, keyMatches), this.justValue);
    }
}

