/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Transform;

public class Iterables {
    private Iterables() {
    }

    public static <T> void add(Collection<T> collection, Iterable<? extends T> items) {
        Iterables.add(collection, items, false);
    }

    public static <T> void add(Collection<T> collection, Iterable<? extends T> items, boolean ignoreNulls) {
        Iterators.add(collection, items == null ? null : items.iterator(), ignoreNulls);
    }

    public static <T> int compare(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        return Iterators.compare(i1.iterator(), i2.iterator());
    }

    public static <T> boolean contains(Iterable<? extends T> items, Selector<? extends T> condition) {
        return null != Iterables.selectFirst(items, condition);
    }

    public static <T> Iterable<T> empty() {
        return Collections.emptyList();
    }

    public static <T> boolean equals(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        return Iterators.equals(i1.iterator(), i2.iterator());
    }

    public static final <T> T first(Iterable<? extends T> items) {
        if (items == null) {
            return null;
        }
        return Iterators.nextOrNull(items.iterator());
    }

    public static final <T> Iterable<T> iterable(T ... items) {
        return new ArrayIterable(items);
    }

    public static String join(Iterable<?> items, String separator) {
        return Iterators.join(items.iterator(), separator);
    }

    public static String asString(Iterable<?> items) {
        StringBuilder b = new StringBuilder("[");
        b.append(Iterables.join(items, ", "));
        b.append("]");
        return b.toString();
    }

    public static <T> Iterable<T> merge(Iterable<? extends T> existingItems, Iterable<? extends T> items) {
        ArrayList newItems = new ArrayList();
        Iterables.add(newItems, items);
        LinkedHashSet mergedItems = new LinkedHashSet();
        Iterables.add(mergedItems, existingItems);
        for (T existing : existingItems) {
            Iterator n = newItems.iterator();
            while (n.hasNext()) {
                Object newItem = n.next();
                boolean matched = existing == newItem || existing.equals(newItem);
                if (!matched) continue;
                n.remove();
            }
        }
        mergedItems.addAll(newItems);
        return mergedItems;
    }

    public static final <T> Iterable<T> select(final Iterable<? extends T> items, final Selector<? extends T> condition) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.select(items.iterator(), condition);
            }

            public String toString() {
                return "[" + items + "," + condition + "]";
            }
        };
    }

    public static final <T> T selectFirst(Iterable<? extends T> items, Selector<? extends T> condition) {
        return Iterators.nextOrNull(Iterators.select(items.iterator(), condition));
    }

    public static final <T> Iterable<T> subsequent(Iterable<T> items) {
        Iterator<T> iter = items.iterator();
        if (iter.hasNext()) {
            iter.next();
            return new SubsequentIterable(items);
        }
        return Iterables.empty();
    }

    public static final <X, Y> Iterable<Y> transform(Iterable<X> items, Transform<X, Y> transform) {
        return new IterableTransform(items, transform);
    }

    private static final class SubsequentIterable<T>
    implements Iterable<T> {
        private final Iterable<T> items;

        private SubsequentIterable(Iterable<T> items) {
            this.items = items;
        }

        @Override
        public Iterator<T> iterator() {
            Iterator<T> iter = this.items.iterator();
            if (iter.hasNext()) {
                iter.next();
                return iter;
            }
            return Iterators.empty();
        }

        public String toString() {
            return Iterables.asString(this);
        }
    }

    private static final class IterableTransform<X, Y>
    implements Iterable<Y>,
    Closeable {
        private final Iterable<X> items;
        private final Transform<X, Y> transform;

        private IterableTransform(Iterable<X> items, Transform<X, Y> transform) {
            this.items = items;
            this.transform = transform;
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.items);
        }

        @Override
        public Iterator<Y> iterator() {
            return Iterators.transform(this.items.iterator(), this.transform);
        }

        public String toString() {
            return "[" + this.items + "," + this.transform + "]";
        }
    }

    private static final class ArrayIterable<T>
    implements Iterable<T> {
        private final T[] items;

        private ArrayIterable(T[] items) {
            this.items = items;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.iterator(this.items);
        }

        public String toString() {
            return Arrays.toString(this.items);
        }
    }
}

