/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Text;

public abstract class ConfigFiles {
    private ConfigFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void load(Properties properties, File file) throws IOException {
        if (file.exists()) {
            InputStream in = null;
            try {
                in = Files.inputStream(file);
                ConfigFiles.load(properties, in);
            }
            finally {
                Closeables.close(in);
            }
        }
    }

    public static void load(Properties properties, InputStream in) throws IOException {
        properties.loadFromXML(in);
    }

    public static synchronized void save(Properties properties, File file) throws IOException {
        OutputStream out = null;
        try {
            Files.createParentFolder(file);
            out = Files.outputStream(file);
            ConfigFiles.store(out, properties);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            Closeables.close(out);
        }
    }

    private static void store(OutputStream out, Properties properties) throws IOException {
        properties.storeToXML(out, "Saved on " + new Date(), Text.defaultEncoding());
    }

    public static InputStream toInputStream(Properties properties) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ConfigFiles.store(bytes, properties);
        return new ByteArrayInputStream(bytes.toByteArray());
    }
}

