/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;

public class ChunkedInputStream
extends InputStream {
    private byte[] buf;
    private final Chunker chunker;
    private final boolean more = true;
    private int pos = 0;

    public ChunkedInputStream(Chunker chunker) {
        this.chunker = chunker;
    }

    @Override
    public void close() throws IOException {
        this.chunker.close();
        super.close();
    }

    @Override
    public int read() throws IOException {
        if (!this.checkBuffer()) {
            return -1;
        }
        int c = ChunkedInputStream.unsignedByteToInt(this.buf[this.pos]);
        ++this.pos;
        if (this.pos >= this.buf.length) {
            this.buf = null;
        }
        return c;
    }

    protected Chunker getChunker() {
        return this.chunker;
    }

    private boolean checkBuffer() throws IOException {
        if (this.buf == null) {
            this.buf = (byte[])(this.chunker.hasNext() ? (byte[])this.chunker.next() : null);
            this.pos = 0;
        }
        if (this.buf == null || this.buf.length == 0) {
            this.buf = null;
            return false;
        }
        return true;
    }

    public static <T> Chunker chunker(Transform<T, byte[]> transform, Iterator<T> items) {
        final Iterator<byte[]> chunks = Iterators.transform(items, transform);
        return new Chunker(){

            @Override
            public void close() throws IOException {
                Closeables.close(chunks);
            }

            @Override
            public boolean hasNext() {
                return chunks.hasNext();
            }

            @Override
            public byte[] next() {
                return (byte[])chunks.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static interface Chunker
    extends Iterator<byte[]>,
    Closeable {
    }
}

