/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.security.Principal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;

public final class AnonymousPrincipal
implements Principal {
    public static final AnonymousPrincipal ANONYMOUS = new AnonymousPrincipal();
    private static final NotAnonymous NOT_ANONYMOUS = new NotAnonymous();

    private AnonymousPrincipal() {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String toString() {
        return "anonymous";
    }

    public static Iterable<Principal> notAnonymous(Iterable<Principal> principals) {
        return Iterables.select(principals, NOT_ANONYMOUS);
    }

    private static final class NotAnonymous
    implements Selector<Principal> {
        private NotAnonymous() {
        }

        @Override
        public Boolean apply(Principal x) {
            return ANONYMOUS != x;
        }
    }
}

