/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.URLEncoding;

public class GenerateServicesDescriptor {
    public static synchronized void generateDescriptor(String packageName, String ... validRoots) {
        try {
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = parent.getResources(path);
            ArrayList<File> roots = new ArrayList<File>();
            if (resources != null) {
                while (resources.hasMoreElements()) {
                    File root;
                    URL url = resources.nextElement();
                    if (!url.getProtocol().equals("file") || !GenerateServicesDescriptor.isValidRoot(validRoots, root = GenerateServicesDescriptor.root(URLEncoding.decode(url.getFile())))) continue;
                    roots.add(root);
                }
            }
            FolderClassLoader cl = new FolderClassLoader(parent, new String[]{packageName}, roots.toArray(new File[roots.size()]));
            for (File root : roots) {
                TreeSet<String> services = new TreeSet<String>();
                GenerateServicesDescriptor.process(cl, services, root, root);
                GenerateServicesDescriptor.writeServiceDescriptor(services, root);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        String packageName = "oracle.dbtools";
        GenerateServicesDescriptor.generateDescriptor("oracle.dbtools", "classes");
    }

    private static Class<?> clazz(ClassLoader loader, File root, File child) {
        String rootPath = root.getAbsolutePath();
        String childPath = child.getAbsolutePath();
        String relativePath = childPath.substring(rootPath.length() + 1);
        String name = relativePath.substring(0, relativePath.length() - ".class".length());
        String className = name.replace(File.separatorChar, '.');
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static boolean isValidRoot(String[] validRoots, File root) {
        if (NullOrEmpty.nullOrEmpty(validRoots)) {
            return true;
        }
        String name = root.getName();
        for (String validRoot : validRoots) {
            if (!validRoot.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static void process(ClassLoader loader, Set<String> services, File root, File folder) throws ClassNotFoundException {
        File[] children;
        Class<?> serviceAnnotation = loader.loadClass(Service.class.getName());
        for (File child : children = folder.listFiles()) {
            Object service;
            Class<?> clazz;
            if (child.isDirectory()) {
                GenerateServicesDescriptor.process(loader, services, root, child);
                continue;
            }
            if (!child.getName().endsWith(".class") || (clazz = GenerateServicesDescriptor.clazz(loader, root, child)) == null || (service = clazz.getAnnotation(serviceAnnotation)) == null) continue;
            services.add(clazz.getName());
        }
    }

    private static File root(String packagePath) {
        return Files.file(packagePath).getParentFile().getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeServiceDescriptor(Set<String> services, File root) throws IOException {
        if (!services.isEmpty()) {
            Writer fw = null;
            try {
                File descriptor = Files.file(root, "META-INF/oracle.dbtools.common.services");
                descriptor.getParentFile().mkdirs();
                fw = Files.writer(descriptor);
                for (String service : services) {
                    fw.append(service);
                    fw.append("\n");
                }
            }
            finally {
                Closeables.close(fw);
            }
        }
    }

    private static class FolderClassLoader
    extends ClassLoader {
        private final String[] packagePrefixes;
        private final File[] roots;

        public FolderClassLoader(ClassLoader parent, String[] packagePrefixes, File ... roots) {
            super(parent);
            if (NullOrEmpty.nullOrEmpty(roots)) {
                throw new IllegalArgumentException("No root directories specified");
            }
            this.roots = roots;
            this.packagePrefixes = packagePrefixes;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                boolean matchedPrefix = false;
                for (String packagePrefix : this.packagePrefixes) {
                    if (!name.startsWith(packagePrefix)) continue;
                    matchedPrefix = true;
                    break;
                }
                if (matchedPrefix) {
                    c = this.loadClassFromFolder(name);
                }
                if (c == null) {
                    c = this.findSystemClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        private File findFile(String filename) {
            for (File root : this.roots) {
                File f = Files.file(root, filename);
                if (!f.exists()) continue;
                return f;
            }
            return null;
        }

        private byte[] loadClassData(String filename) throws IOException, ClassNotFoundException {
            File f = this.findFile(filename);
            if (f == null) {
                throw new ClassNotFoundException("Could not find file named: " + filename);
            }
            int size = (int)f.length();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(size);
            FileInputStream fis = new FileInputStream(f);
            StreamCopy.drain(fis, bytes);
            ((InputStream)fis).close();
            return bytes.toByteArray();
        }

        private Class<?> loadClassFromFolder(String name) throws ClassNotFoundException, ClassFormatError {
            Class<?> c = null;
            String filename = name.replace('.', File.separatorChar) + ".class";
            try {
                byte[] data = this.loadClassData(filename);
                c = this.defineClass(name, data, 0, data.length);
                if (c == null) {
                    throw new ClassNotFoundException(name);
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Error reading file: " + filename);
            }
            return c;
        }
    }
}

