/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import oracle.dbtools.common.config.ConfigurationBase;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.ConfigFiles;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.SortedProperties;

public class PropertiesConfiguration
extends ConfigurationBase {
    private final AssociativeArray<String, String> values;

    public PropertiesConfiguration(InputStream content) throws IOException {
        this(PropertiesConfiguration.properties(content));
    }

    public PropertiesConfiguration(Properties properties) {
        this.values = PropertiesConfiguration.asArray(properties);
    }

    @Override
    protected AssociativeArray<String, String> values() {
        return this.values;
    }

    private static AssociativeArray<String, String> asArray(Properties props) {
        return new FromProperties(props);
    }

    private static Properties properties(InputStream content) throws IOException {
        SortedProperties props = new SortedProperties();
        ConfigFiles.load((Properties)props, content);
        return props;
    }

    public static final class FromProperties
    extends AssociativeArrays.Base<String, String> {
        private final Properties props;

        public FromProperties(Properties props) {
            this.props = props;
        }

        @Override
        public String get(Object key) {
            return this.props.getProperty(key.toString());
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.transform(this.props.keySet().iterator(), Iterators.AS_STRING);
        }
    }
}

