/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util.codec;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class GIFDecoder {
    protected final char[] MAGIC_ID = new char[]{'G', 'I', 'F', '8'};
    protected final int GIF_87A = 1;
    protected final int GIF_89A = 2;
    protected final int GIF_EXT_CODE = 33;
    protected final int GIF_IMG_CODE = 44;
    protected final int GIF_END_CODE = 59;
    protected final int GIF_GRFCTRL_EXT = 249;
    protected final int GIF_COMMENT_EXT = 254;
    protected DataInputStream input;
    protected GIFFileHeader fileHeader;
    private WritableRaster theTile = null;
    private PixelInterleavedSampleModel sampleModel = null;
    private IndexColorModel colorModel = null;
    int width = 0;
    int height = 0;
    int transparentColor = -1;
    int localLeft = 0;
    int localTop = 0;
    int localWidth = 0;
    int localHeight = 0;
    boolean isInterlaced = false;
    int initialCodeSize = 0;
    int clearCode = 0;
    int endCode = 0;
    int nextFreeCode = 0;
    int codeSize = 0;
    byte[] lzwByteDict = null;
    int[] lzwParentDict = null;
    int bufOffset = 0;
    int xPos = 0;
    int yPos = 0;
    int yIncr = 0;
    int pass = 0;
    byte[] pixelStack = null;
    byte[] bitStore = null;
    int bitStoreOff = 0;
    int bitOffset = 0;
    int bitsLeft = 0;
    private static int[] maskFromCodeSize = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095};
    private static int[] incrFromPass = new int[]{8, 8, 4, 2};
    private static int[] yposStartFromPass = new int[]{0, 4, 2, 1};
    private static int[] maxCode = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095};

    public static BufferedImage decodeGIFStream(InputStream inputStream) {
        GIFDecoder theDecoder = new GIFDecoder(inputStream);
        WritableRaster raster = theDecoder.getRaster();
        return new BufferedImage(theDecoder.colorModel, raster, false, null);
    }

    private GIFDecoder(InputStream inputStream) {
        this.input = new DataInputStream(inputStream);
        this.fileHeader = new GIFFileHeader();
        this.fileHeader.readFromStream(this.input);
        this.width = this.fileHeader.globalWidth;
        this.height = this.fileHeader.globalHeight;
        this.colorModel = this.fileHeader.globalColorTable;
        this.sampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, 1, this.width, new int[]{0});
        this.parseDataStream();
    }

    private WritableRaster getRaster() {
        DataBufferByte dbuf = new DataBufferByte(this.width * this.height);
        Point origin = new Point(0, 0);
        this.theTile = Raster.createWritableRaster(this.sampleModel, dbuf, origin);
        byte[] buf = dbuf.getData();
        if ((this.localLeft != 0 || this.localTop != 0 || this.localWidth < this.width || this.localHeight < this.height) && this.fileHeader.backgroundColorIndex != 0) {
            int i = 0;
            while (i < buf.length) {
                buf[i] = (byte)this.fileHeader.backgroundColorIndex;
                ++i;
            }
        }
        try {
            this.lzwDecode(buf);
        }
        catch (IOException e) {
            throw new RuntimeException("GIF stream terminated prematurely");
        }
        return this.theTile;
    }

    private void parseDataStream() {
        try {
            int blockCode = 0;
            while (blockCode != 44) {
                blockCode = this.input.read();
                switch (blockCode) {
                    case 59: {
                        throw new IOException("found GIF file term code");
                    }
                    case -1: {
                        throw new IOException("couldn't read block code");
                    }
                    case 33: {
                        this.handleExtensionBlock();
                        break;
                    }
                    case 44: {
                        this.handleImageBlock();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported GIF block code found");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("GIF stream terminated prematurely");
        }
    }

    private void handleExtensionBlock() throws IOException {
        int extensionCode = this.input.read();
        switch (extensionCode) {
            case -1: {
                throw new IOException("couldn't read extension code");
            }
            case 249: {
                this.handleGraphicsControlExt();
                break;
            }
            default: {
                this.skipBlockSequence();
            }
        }
    }

    private void handleGraphicsControlExt() throws IOException {
        byte[] block = new byte[6];
        try {
            this.input.readFully(block);
        }
        catch (EOFException eof) {
            throw new EOFException("couldn't read graphics extension block");
        }
        byte size = block[0];
        if (size != 4) {
            throw new IOException("Invalid Graphics Control Extension block in GIF image");
        }
        byte bitField = block[1];
        if ((bitField & 1) == 1) {
            this.transparentColor = block[4] & 0xFF;
        }
        if (block[5] != 0) {
            throw new IOException("Graphics Control Extension block terminated incorrectly in GIF image");
        }
    }

    private void skipBlockSequence() throws IOException {
        int size = this.input.read();
        while (size != 0) {
            this.input.skip(size);
            size = this.input.read();
        }
        if (size == -1) {
            throw new IOException("eof while skipping block");
        }
    }

    private void handleImageBlock() throws IOException {
        boolean localCTExists;
        this.localLeft = GIFDecoder.readUnsignedShortLE(this.input);
        this.localTop = GIFDecoder.readUnsignedShortLE(this.input);
        this.localWidth = GIFDecoder.readUnsignedShortLE(this.input);
        this.localHeight = GIFDecoder.readUnsignedShortLE(this.input);
        int bitField = this.input.readUnsignedByte();
        if (bitField == -1) {
            throw new IOException("eof while reading local image header");
        }
        this.isInterlaced = (bitField >> 6 & 1) == 1;
        boolean bl = localCTExists = (bitField >> 7 & 1) == 1;
        if (localCTExists) {
            int localCTSize = 1 << (bitField & 7) + 1;
            byte[] r = new byte[localCTSize];
            byte[] g = new byte[localCTSize];
            byte[] b = new byte[localCTSize];
            byte[] all = new byte[localCTSize * 3];
            try {
                this.input.readFully(all);
            }
            catch (EOFException eof) {
                throw new EOFException("eof while reading local color table");
            }
            int i = 0;
            while (i < localCTSize) {
                r[i] = all[i * 3];
                g[i] = all[i * 3 + 1];
                b[i] = all[i * 3 + 2];
                ++i;
            }
            this.colorModel = this.transparentColor == -1 ? new IndexColorModel(this.fileHeader.bitsPerPixel, localCTSize, r, g, b) : new IndexColorModel(this.fileHeader.bitsPerPixel, localCTSize, r, g, b, this.transparentColor);
        } else if (this.transparentColor != -1) {
            IndexColorModel globalCT = this.fileHeader.globalColorTable;
            byte[] r = new byte[this.fileHeader.globalCTSize];
            byte[] g = new byte[this.fileHeader.globalCTSize];
            byte[] b = new byte[this.fileHeader.globalCTSize];
            globalCT.getReds(r);
            globalCT.getGreens(g);
            globalCT.getBlues(b);
            this.colorModel = new IndexColorModel(this.fileHeader.bitsPerPixel, r.length, r, g, b, this.transparentColor);
        } else {
            this.colorModel = this.fileHeader.globalColorTable;
        }
        this.initialCodeSize = this.input.read();
        if (this.initialCodeSize == -1) {
            throw new IOException("eof while reading root code size");
        }
    }

    private void lzwDecode(byte[] buf) throws IOException {
        this.initLZWDecoder();
        this.initBitStore();
        this.initOutputStream();
        int thisCode = 0;
        int lastCode = 0;
        while ((thisCode = this.getCode()) != this.endCode) {
            if (this.clearCode == thisCode) {
                this.initLZWDictionary();
                while (this.clearCode == thisCode) {
                    thisCode = this.getCode();
                }
                if (this.endCode == thisCode) break;
                this.outputCodeString(buf, thisCode);
            } else if (this.codeInTable(thisCode)) {
                this.outputCodeString(buf, thisCode);
                this.addStringToTable(lastCode, this.rootByte(thisCode));
            } else {
                this.addStringToTable(lastCode, this.rootByte(lastCode));
                this.outputCodeString(buf, this.nextFreeCode - 1);
            }
            lastCode = thisCode;
        }
    }

    private void initLZWDecoder() {
        this.clearCode = 1 << this.initialCodeSize;
        this.endCode = this.clearCode + 1;
        this.lzwByteDict = new byte[4096];
        this.lzwParentDict = new int[4096];
        int i = 0;
        while (i < this.clearCode) {
            this.lzwByteDict[i] = (byte)i;
            this.lzwParentDict[i] = -1;
            ++i;
        }
        this.initLZWDictionary();
    }

    private void initLZWDictionary() {
        this.nextFreeCode = this.clearCode + 2;
        this.codeSize = this.initialCodeSize + 1;
    }

    private boolean codeInTable(int code) {
        return code < this.nextFreeCode;
    }

    private byte rootByte(int code) {
        while (this.lzwParentDict[code] >= 0) {
            code = this.lzwParentDict[code];
        }
        return this.lzwByteDict[code];
    }

    private void addStringToTable(int code, byte b) {
        this.lzwByteDict[this.nextFreeCode] = b;
        this.lzwParentDict[this.nextFreeCode] = code;
        if (maxCode[this.codeSize] == this.nextFreeCode && this.codeSize < 12) {
            ++this.codeSize;
        }
        ++this.nextFreeCode;
    }

    private void initBitStore() {
        this.bitStore = new byte[257];
        this.bitStoreOff = 0;
        this.bitOffset = 0;
        this.bitsLeft = 0;
    }

    private int getCode() throws IOException {
        if (this.codeSize > this.bitsLeft) {
            int blockLen = this.input.read();
            if (0 == blockLen) {
                return this.endCode;
            }
            if (blockLen < 1) {
                throw new IOException("block length returned as " + blockLen);
            }
            int storeStart = 0;
            if (this.bitsLeft > 0) {
                storeStart = 1;
                this.bitStore[0] = this.bitStore[this.bitStoreOff];
                if (this.bitOffset + this.bitsLeft > 8) {
                    storeStart = 2;
                    this.bitStore[1] = this.bitStore[this.bitStoreOff + 1];
                }
            }
            try {
                this.input.readFully(this.bitStore, storeStart, blockLen);
            }
            catch (EOFException eof) {
                throw new EOFException("couldn't read image block");
            }
            this.bitStoreOff = 0;
            this.bitsLeft += blockLen * 8;
            return this.getCode();
        }
        int mask = maskFromCodeSize[this.codeSize] << this.bitOffset;
        int data = mask & this.bitStore[this.bitStoreOff] & 0xFF;
        if (this.bitOffset + this.codeSize > 8) {
            data += this.bitStore[this.bitStoreOff + 1] << 8 & mask & 0xFF00;
            if (this.bitOffset + this.codeSize > 16) {
                data += this.bitStore[this.bitStoreOff + 2] << 16 & mask & 0xFF0000;
            }
        }
        data >>= this.bitOffset;
        this.bitsLeft -= this.codeSize;
        this.bitOffset += this.codeSize;
        while (this.bitOffset > 7) {
            this.bitOffset -= 8;
            ++this.bitStoreOff;
        }
        if (data > this.nextFreeCode) {
            throw new RuntimeException("Illegal LZW code in stream");
        }
        return data;
    }

    private void initOutputStream() {
        this.bufOffset = this.localTop * this.width + this.localLeft;
        this.xPos = 0;
        this.pass = 0;
        if (this.isInterlaced) {
            this.yIncr = incrFromPass[this.pass];
            this.yPos = yposStartFromPass[this.pass];
        } else {
            this.yIncr = 1;
            this.yPos = 0;
        }
        this.pixelStack = new byte[4096];
    }

    private void outputCodeString(byte[] imgBuf, int code) {
        if (this.pass >= incrFromPass.length) {
            return;
        }
        int numPixels = 0;
        while (code >= 0) {
            this.pixelStack[numPixels++] = this.lzwByteDict[code];
            code = this.lzwParentDict[code];
        }
        int i = numPixels - 1;
        while (i >= 0) {
            imgBuf[this.bufOffset + this.yPos * this.width + this.xPos] = this.pixelStack[i];
            ++this.xPos;
            if (this.xPos >= this.localWidth) {
                this.xPos = 0;
                this.yPos += this.yIncr;
                if (this.yPos >= this.localHeight) {
                    ++this.pass;
                    if (this.pass >= incrFromPass.length) break;
                    this.yIncr = incrFromPass[this.pass];
                    this.yPos = yposStartFromPass[this.pass];
                }
            }
            --i;
        }
    }

    private static int readUnsignedShortLE(InputStream input) throws IOException {
        int byte2;
        int byte1 = input.read();
        if ((byte1 | (byte2 = input.read())) < 0) {
            throw new EOFException();
        }
        return (byte2 << 8) + byte1;
    }

    protected class GIFFileHeader {
        int version = 0;
        int globalWidth = 0;
        int globalHeight = 0;
        boolean globalCTExists = false;
        int globalCTSize = 0;
        boolean globalCTSorted = false;
        int bitsPerPixel = 0;
        int backgroundColorIndex = 0;
        int aspectRatioNumerator = 0;
        IndexColorModel globalColorTable = null;

        protected GIFFileHeader() {
        }

        protected void readFromStream(DataInputStream in) {
            try {
                int i = 0;
                while (i < GIFDecoder.this.MAGIC_ID.length) {
                    if (in.read() != GIFDecoder.this.MAGIC_ID[i]) {
                        throw new RuntimeException("Invalid magic value for GIF image");
                    }
                    ++i;
                }
                char v1 = (char)in.read();
                char v2 = (char)in.read();
                if (v1 == '7' && v2 == 'a') {
                    this.version = 1;
                } else if (v1 == '9' && v2 == 'a') {
                    this.version = 2;
                } else {
                    throw new RuntimeException("Unsupported GIF version");
                }
                this.globalWidth = GIFDecoder.readUnsignedShortLE(in);
                this.globalHeight = GIFDecoder.readUnsignedShortLE(in);
                if (this.globalWidth < 1 || this.globalHeight < 1) {
                    throw new RuntimeException("GIF Image has invalid dimensions");
                }
                int bitField = in.readUnsignedByte();
                boolean bl = this.globalCTExists = (bitField >> 7 & 1) == 1;
                if (this.globalCTExists) {
                    this.globalCTSize = 1 << (bitField & 7) + 1;
                    if ((bitField >> 3 & 1) == 1) {
                        this.globalCTSorted = true;
                    }
                }
                this.bitsPerPixel = (bitField >> 4 & 7) + 1;
                this.backgroundColorIndex = in.readUnsignedByte();
                this.aspectRatioNumerator = in.readUnsignedByte();
                if (this.globalCTExists) {
                    byte[] r = new byte[this.globalCTSize];
                    byte[] g = new byte[this.globalCTSize];
                    byte[] b = new byte[this.globalCTSize];
                    byte[] all = new byte[this.globalCTSize * 3];
                    in.readFully(all);
                    int i2 = 0;
                    while (i2 < this.globalCTSize) {
                        r[i2] = all[i2 * 3];
                        g[i2] = all[i2 * 3 + 1];
                        b[i2] = all[i2 * 3 + 2];
                        ++i2;
                    }
                    this.globalColorTable = new IndexColorModel(this.bitsPerPixel, this.globalCTSize, r, g, b);
                } else {
                    int numColors = 1 << this.bitsPerPixel;
                    byte[] r = new byte[numColors];
                    byte[] g = new byte[numColors];
                    byte[] b = new byte[numColors];
                    b[0] = 0;
                    g[0] = 0;
                    r[0] = 0;
                    int i3 = 1;
                    while (i3 < numColors) {
                        b[i3] = -1;
                        g[i3] = -1;
                        r[i3] = -1;
                        ++i3;
                    }
                    this.globalColorTable = new IndexColorModel(this.bitsPerPixel, numColors, r, g, b);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

