/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.io;

public class StringParser {
    private String data = null;
    private int currentPos = 0;

    public StringParser(String toParse) {
        this.data = toParse;
    }

    public String getData() {
        return this.data;
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public void setCurrentPos(int pos) {
        this.currentPos = pos;
    }

    public char currentChar() {
        if (this.currentPos >= this.data.length()) {
            return '\u0000';
        }
        return this.data.charAt(this.currentPos);
    }

    public StringParser skipChar() {
        ++this.currentPos;
        return this;
    }

    public boolean hasMoreData() {
        return this.currentPos < this.data.length();
    }

    public String remainder() {
        return this.data.substring(this.currentPos);
    }

    public String nextToken() throws Exception {
        return this.nextToken(" ,");
    }

    public String nextToken(String delims) throws Exception {
        int start = this.currentPos;
        this.skipTo(delims);
        if (start == this.currentPos) {
            throw new Exception("Parse failure: no next token");
        }
        int end = this.currentPos;
        return this.data.substring(start, end);
    }

    public int nextInteger() throws Exception {
        return this.nextInteger(" ,");
    }

    public int nextInteger(String delims) throws Exception {
        int start = this.currentPos;
        this.skip("1234567890.-+");
        if (this.currentPos == start) {
            throw new Exception("Parse failure: no next integer");
        }
        if (this.data.substring(start, this.currentPos).indexOf(46) != -1) {
            throw new Exception("Parse failure: improper integer format");
        }
        return Integer.parseInt(this.data.substring(start, this.currentPos));
    }

    public long nextLong() throws Exception {
        return this.nextLong(" ,");
    }

    public long nextLong(String delims) throws Exception {
        int start = this.currentPos;
        this.skip("1234567890.-+");
        if (this.currentPos == start) {
            throw new Exception("Parse failure: no next long integer");
        }
        if (this.data.substring(start, this.currentPos).indexOf(46) != -1) {
            throw new Exception("Parse failure: improper long integer format");
        }
        return Long.parseLong(this.data.substring(start, this.currentPos));
    }

    public float nextFloat() throws Exception {
        return this.nextFloat(" ,");
    }

    public float nextFloat(String delims) throws Exception {
        int start = this.currentPos;
        this.skip("1234567890.-+");
        if (this.currentPos == start) {
            throw new Exception("Parse failure: no next float");
        }
        return Float.parseFloat(this.data.substring(start, this.currentPos));
    }

    public int nextPattern(String[] patterns) throws Exception {
        int i = 0;
        while (i < patterns.length) {
            String prefix;
            if (patterns[i].length() == 0) {
                return i;
            }
            if (this.currentPos + patterns[i].length() <= this.data.length() && (prefix = this.data.substring(this.currentPos, this.currentPos + patterns[i].length())).equalsIgnoreCase(patterns[i])) {
                this.currentPos += patterns[i].length();
                return i;
            }
            ++i;
        }
        throw new Exception("Parse failure: no next pattern");
    }

    public String nextGroup() throws Exception {
        return this.nextGroup("(", ")");
    }

    public String nextGroup(String delims) throws Exception {
        return this.nextGroup(delims, delims);
    }

    public String nextGroup(String openDelims, String closeDelims) throws Exception {
        int start = this.currentPos;
        this.skip(openDelims);
        if (this.currentPos == start) {
            throw new Exception("Parse failure: no delimited group");
        }
        int startGroup = this.currentPos;
        this.skipTo(closeDelims);
        if (closeDelims.indexOf(this.currentChar()) < 0) {
            this.currentPos = start;
            throw new Exception("Parse failure: unclosed delimited group");
        }
        String group = this.data.substring(startGroup, this.currentPos);
        this.skip(closeDelims);
        return group;
    }

    public StringParser skip() {
        return this.skip(" ");
    }

    public StringParser skip(String chaff) {
        while (this.currentPos < this.data.length() && chaff.indexOf(this.data.charAt(this.currentPos)) >= 0) {
            ++this.currentPos;
        }
        return this;
    }

    public StringParser skipTo(String delims) {
        while (this.currentPos < this.data.length() && delims.indexOf(this.data.charAt(this.currentPos)) < 0) {
            ++this.currentPos;
        }
        return this;
    }
}

