/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ide.inspector.layout.CategoryLayout;
import oracle.ide.inspector.layout.Element;
import oracle.ide.util.NameValuePair;
import oracle.ideimpl.inspector.PIHook;
import oracle.ideimpl.inspector.layout.DefaultElementFactory;
import oracle.ideimpl.inspector.layout.DefaultExtensibleGroup;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public final class DefaultCategoryLayout
extends CategoryLayout {
    private HashStructure _hash;
    private DefaultExtensibleGroup _xgroup;
    private CategoryLayout _base;
    private List<Element> _groups;

    public DefaultCategoryLayout(HashStructure hash) {
        this(hash, new DefaultExtensibleGroup("category-layout", hash));
    }

    DefaultCategoryLayout(HashStructure hash, DefaultExtensibleGroup extensibleGroup) {
        this._hash = hash;
        this._xgroup = extensibleGroup;
    }

    public String getID() {
        return this._hash.getString("id");
    }

    @Override
    public String getExtends() {
        return this._hash.getString("extends");
    }

    @Override
    public List<Element> getChildren() {
        if (this._groups != null) {
            return this._groups;
        }
        this._groups = new ArrayList<Element>();
        CategoryLayout base = this.getBase();
        if (base != null) {
            this._groups.addAll(this.getBase().getChildren());
        }
        Collection structures = PIHook.getPIHook().getOrderedElements(this._hash);
        for (NameValuePair pair : structures) {
            Element element = DefaultElementFactory.createElement(pair.getName(), (HashStructure)pair.getValue());
            if (element == null) continue;
            this._groups.add(element);
        }
        return this._groups;
    }

    DefaultCategoryLayout() {
    }

    @Override
    public CategoryLayout getBase() {
        if (this._base != null) {
            return this._base;
        }
        String baseID = this.getExtends();
        if (baseID == null || baseID.length() == 0) {
            return this._base;
        }
        HashStructure hash = PIHook.getPIHook().getExtensibleElement(baseID, "category-layout");
        if (hash != null) {
            this._base = new DefaultCategoryLayout(hash);
        }
        return this._base;
    }

    @Override
    public String getPartOf() {
        return this._hash.getString("part-of");
    }

    @Override
    public String getTitle() {
        return this._xgroup.getTitle();
    }

    @Override
    public String getHint() {
        return this._xgroup.getHint();
    }

    @Override
    public Boolean isExpanded() {
        if (this._hash.containsKey("expanded")) {
            return this._hash.getBoolean("expanded");
        }
        return false;
    }

    @Override
    public Boolean isSelected() {
        return this._hash.getBoolean("selected");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultCategoryLayout)) {
            return false;
        }
        DefaultCategoryLayout other = (DefaultCategoryLayout)object;
        if (!ModelUtil.areEqual((Object)this.getID(), (Object)other.getID())) {
            return false;
        }
        if (!ModelUtil.areEqual((Object)this.getExtends(), (Object)other.getExtends())) {
            return false;
        }
        if (!ModelUtil.areEqual((Object)this.getPartOf(), (Object)other.getPartOf())) {
            return false;
        }
        if (!ModelUtil.areEqual((Object)this.getTitle(), (Object)other.getTitle())) {
            return false;
        }
        return ModelUtil.areEqual((Object)this.getHint(), (Object)other.getHint());
    }

    public int hashCode() {
        int PRIME = 37;
        int result = super.hashCode();
        result = 37 * result + ModelUtil.hashCodeFor((Object)this.getID());
        result = 37 * result + ModelUtil.hashCodeFor((Object)this.getExtends());
        result = 37 * result + ModelUtil.hashCodeFor((Object)this.getPartOf());
        result = 37 * result + ModelUtil.hashCodeFor((Object)this.getTitle());
        result = 37 * result + ModelUtil.hashCodeFor((Object)this.getHint());
        return result;
    }
}

