/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import oracle.ide.controls.Toolbar;
import oracle.ideimpl.docking.AutoExpandListener;

final class InspectorToolbar
extends Toolbar {
    final Toolbar customToolbarButtonsContainer = new Toolbar();
    final Component horizontalGlue = Box.createHorizontalGlue();
    AutoExpandListener autoExpandListener;
    private boolean layoutSealed;

    InspectorToolbar() {
    }

    void unsealLayout() {
        this.layoutSealed = false;
    }

    void sealLayout() {
        this.layoutSealed = true;
    }

    public Component add(Component comp) {
        if (this.layoutSealed && this.customToolbarButtonsContainer != comp) {
            return this.customToolbarButtonsContainer.add(comp);
        }
        return super.add(comp);
    }

    public void removeAll() {
        super.removeAll();
        this.customToolbarButtonsContainer.removeAll();
    }

    public void remove(Component comp) {
        if (this.layoutSealed) {
            this.customToolbarButtonsContainer.remove(comp);
            return;
        }
        super.remove(comp);
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.updateAutoExpandListener(l);
        super.addMouseListener(l);
    }

    private void updateAutoExpandListener(MouseListener listener) {
        this.autoExpandListener = null;
        if (!(listener instanceof AutoExpandListener)) {
            return;
        }
        this.autoExpandListener = (AutoExpandListener)listener;
        this.addAutoExpandListenerTo(new Component[]{this.customToolbarButtonsContainer, this.horizontalGlue});
    }

    private void addAutoExpandListenerTo(Component ... components) {
        for (Component c : components) {
            c.addMouseListener((MouseListener)this.autoExpandListener);
            c.addMouseMotionListener((MouseMotionListener)this.autoExpandListener);
        }
    }

    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        if (l == this.autoExpandListener) {
            this.removeAutoExpandListenerAsMouseListenerFrom(new Component[]{this.customToolbarButtonsContainer, this.horizontalGlue});
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        if (l == this.autoExpandListener) {
            this.removeAutoExpandListenerAsMouseMotionListenerFrom(new Component[]{this.customToolbarButtonsContainer, this.horizontalGlue});
        }
    }

    private void removeAutoExpandListenerAsMouseListenerFrom(Component ... components) {
        for (Component c : components) {
            c.removeMouseListener((MouseListener)this.autoExpandListener);
        }
    }

    private void removeAutoExpandListenerAsMouseMotionListenerFrom(Component ... components) {
        for (Component c : components) {
            c.removeMouseMotionListener((MouseMotionListener)this.autoExpandListener);
        }
    }

    void addHorizontalGlue() {
        this.add(this.horizontalGlue);
    }
}

