/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.Component;
import java.awt.Window;
import java.beans.VetoableChangeListener;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.inspector.InspectorArb;

public class InspectorGroup
extends oracle.bali.inspector.InspectorGroup {
    protected boolean showAdvancedEditor(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector) {
        JEWTDialog editorDialog = new JEWTDialog(WindowUtils.parentFrame((Component)inspector), this.getAdvancedEditorTitle(propertyID, editorFactory, inspector), 7);
        PropertyModel model = inspector.getPropertyModel();
        int col = model.getColumnIndex(PropertyModel.COLUMN_VALUE);
        Object value = model.getPropertyByID(col, propertyID);
        editorFactory.setEditorValue(value);
        Component advancedEditor = editorFactory.getAdvancedEditor();
        boolean isVetoable = advancedEditor instanceof VetoableChangeListener;
        editorDialog.setResizable(true);
        editorDialog.setContent(advancedEditor);
        editorDialog.setLocale(inspector.getLocale());
        if (isVetoable) {
            editorDialog.addVetoableChangeListener((VetoableChangeListener)((Object)advancedEditor));
        }
        WindowUtils.centerWindow((Window)editorDialog, (Component)inspector);
        JTable table = inspector.getPropertyTable();
        TableCellEditor editor = table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        boolean isOK = editorDialog.runDialog();
        if (isVetoable) {
            editorDialog.removeVetoableChangeListener((VetoableChangeListener)((Object)advancedEditor));
        }
        if (isOK) {
            Object newValue = editorFactory.getEditorValue();
            try {
                model.setPropertyByID(col, propertyID, newValue);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                this.showErrorMessage(propertyID, editorFactory, inspector, th, newValue);
            }
        }
        editorDialog.dispose();
        SwingUtilities.invokeLater(new Cleanup(table));
        return isOK;
    }

    protected void showErrorMessage(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector, Throwable throwable, Object value) {
        String detail;
        JTable table = inspector.getPropertyTable();
        PropertyModel model = inspector.getPropertyModel();
        int index = model.getPropertyIndex(propertyID);
        String name = model.getPropertyDisplayName(index);
        String valString = value != null ? value.toString() : null;
        String msg = null;
        String string = detail = throwable != null ? throwable.getLocalizedMessage() : null;
        msg = detail == null ? (valString == null ? InspectorArb.format(19, new String[]{name, detail}) : InspectorArb.format(20, new String[]{name, valString, detail})) : detail;
        TableCellEditor editor = table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        JMultiLineLabel label = new JMultiLineLabel(msg);
        JOptionPane.showMessageDialog(table, label, IdeArb.getString((int)236), 0);
    }

    private static final class Cleanup
    implements Runnable {
        JTable table;

        Cleanup(JTable table) {
            this.table = table;
        }

        @Override
        public void run() {
            Window window = SwingUtilities.getWindowAncestor(this.table);
            if (window != null) {
                window.toFront();
            }
            this.table.requestFocus();
        }
    }
}

