/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.layout;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.FormLayoutFactory;
import oracle.ide.inspector.layout.PropertyFormLayout;
import oracle.ide.inspector.layout.PropertyFormLayoutAssembly;
import oracle.ideimpl.inspector.PIHook;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class PropertyFormLayoutFactory {
    private static final List<FormLayoutFactory> _factories = new ArrayList<FormLayoutFactory>();

    public static void addFormLayoutFactory(FormLayoutFactory factory) {
        _factories.add(factory);
    }

    public static void removeFormLayoutFactory(FormLayoutFactory factory) {
        _factories.remove(factory);
    }

    public static PropertyFormLayout getPropertyFormLayout(PropertyModel propertyModel) {
        ArrayList<Element> layouts = new ArrayList<Element>();
        for (FormLayoutFactory factory : _factories) {
            PropertyFormLayout pfl = factory.createPropertyFormLayout(propertyModel);
            if (pfl == null) continue;
            layouts.add(pfl);
        }
        if (layouts.isEmpty()) {
            return null;
        }
        if (layouts.size() == 1) {
            return (PropertyFormLayout)layouts.get(0);
        }
        return new PropertyFormLayoutAssembly(layouts);
    }

    public static List<PropertyFormLayout> getExternalPropertyFormLayouts(InputSource source, String extensionID, String rsBundleClassName) {
        return PIHook.getPIHook().getExternalPropertyFormLayouts(source, extensionID, rsBundleClassName);
    }

    public static List<PropertyFormLayout> getExternalPropertyFormLayouts(XMLReader reader, InputSource source, String extensionID, String rsBundleClassName) {
        return PIHook.getPIHook().getExternalPropertyFormLayouts(reader, source, extensionID, rsBundleClassName);
    }

    private PropertyFormLayoutFactory() {
    }
}

