/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import oracle.ide.inspector.AbstractAdditionalPage;
import oracle.ide.inspector.CategoryCollection;
import oracle.ide.inspector.CategoryCollectionDisplay;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyCategoryPanel;
import oracle.ide.inspector.PropertyCategoryPanelHelper;
import oracle.ide.inspector.ScrollToVisibleFocusListeners;
import oracle.ide.inspector.SearchIterator;
import oracle.ide.inspector.UserSelectedCategories;
import oracle.ide.model.Displayable;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderEvent;
import oracle.javatools.ui.HeaderListener;
import oracle.javatools.ui.HeaderPanel;

class VerticalCategoryCollection
extends JPanel
implements CategoryCollection {
    private static final Component[] NO_ADDITIONAL_PAGES = new Component[0];
    private final GridBagConstraints constraints;
    private final Component endGlue = Box.createVerticalGlue();
    private final JPanel additionalTabPanel;
    private final GridBagConstraints additionalTabConstraints;
    private final Map<String, HeaderPanel<JComponent>> categoryHeaderMap = new LinkedHashMap<String, HeaderPanel<JComponent>>();
    private final List<HeaderPanel<JComponent>> categoryHeaders = new ArrayList<HeaderPanel<JComponent>>();
    private final List<PropertyCategoryPanel> categoryPanels = new ArrayList<PropertyCategoryPanel>();
    private Component[] additionalPages;
    private String currentCategory;
    private JScrollPane scrollPane;
    private final CategoryCollectionDisplay categoryCollectionDisplay;
    private final UserSelectedCategories userSelectedCategories;
    private PropertyCategoryPanelHelper categoryPanelHelper = new PropertyCategoryPanelHelper();
    private int lastCategoryInSearch;

    public VerticalCategoryCollection(CategoryCollectionDisplay categoryCollectionDisplay) {
        this.categoryCollectionDisplay = categoryCollectionDisplay;
        this.userSelectedCategories = categoryCollectionDisplay.userSelectedCategories();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.additionalTabPanel = new JPanel(new GridBagLayout());
        this.additionalTabPanel.setBackground(this.getBackground());
        this.constraints = new GridBagConstraints();
        this.resetConstraints(this.constraints);
        this.additionalTabConstraints = new GridBagConstraints();
        this.resetConstraints(this.additionalTabConstraints);
        this.constraints.anchor = 18;
        this.scrollPane = new JScrollPane(this);
        VerticalCategoryCollection.configure(this.scrollPane);
    }

    private void resetConstraints(GridBagConstraints c) {
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
    }

    @Override
    public void currentCategoryUpdated(String currentCategory) {
        this.categoryCollectionDisplay.updateCurrentCategory(currentCategory);
    }

    @Override
    public void categorySelectionChanged(PropertyCategoryPanel selectedPanel) {
        this.categoryCollectionDisplay.categorySelected(selectedPanel);
    }

    @Override
    public boolean findTextInComponent(Component c, String searchText, boolean searchForward, boolean searchRepeat) {
        return this.categoryCollectionDisplay.findTextInComponent(c, searchText, searchForward, searchRepeat);
    }

    @Override
    public List<PropertyCategoryPanel> categoryPanels() {
        return new ArrayList<PropertyCategoryPanel>(this.categoryPanels);
    }

    @Override
    public void addCategory(PropertyCategoryPanel categoryPanelSource, Properties properties) {
        JComponent categoryPanel = categoryPanelSource.categoryPanel();
        HeaderPanel<JComponent> headerPanel = this.createHeaderPanel(categoryPanel);
        headerPanel.setAnimationEnabled(false);
        String title = categoryPanelSource.categoryTitle();
        this.configure(headerPanel, title, categoryPanelSource);
        this.expandIfNecessary(headerPanel, categoryPanelSource, properties);
        this.addCategoryUI(this, title, headerPanel, this.constraints);
        this.categoryPanels.add(categoryPanelSource);
        headerPanel.setAnimationEnabled(true);
    }

    private void expandIfNecessary(HeaderPanel<JComponent> headerPanel, PropertyCategoryPanel categoryPanelSource, Properties properties) {
        Header header = headerPanel.getHeader();
        String title = header.getText();
        boolean wasExpanded = this.userSelectedCategories.isSelected(title);
        Boolean expanded = categoryPanelSource.isDefaultExpanded();
        boolean expandedByDefault = expanded != null ? expanded : false;
        boolean collapsed = this.userSelectedCategories.isUnselected(title);
        boolean isFirstCategory = this.categoryPanels.isEmpty();
        if ((wasExpanded || expandedByDefault || isFirstCategory) && !collapsed) {
            if (!categoryPanelSource.isRendered()) {
                categoryPanelSource.render(properties, Orientation.VERTICAL);
            }
            if (!header.isExpanded()) {
                header.setExpanded(true);
            }
            return;
        }
        if (collapsed) {
            if (header.isExpanded()) {
                header.setExpanded(false);
            }
            return;
        }
        header.setExpanded(false);
    }

    private void configure(final HeaderPanel<JComponent> headerPanel, String text, final PropertyCategoryPanel categoryPanelSource) {
        Header header = headerPanel.getHeader();
        this.configure(header, text);
        header.addHeaderListener(new HeaderListener(){

            public void headerExpanded(HeaderEvent event) {
                VerticalCategoryCollection.this.categorySelectionChanged(categoryPanelSource);
                Container parent = headerPanel.getParent();
                if (!(parent instanceof JComponent)) {
                    return;
                }
                JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, (Component)headerPanel);
                Rectangle headerPanelBounds = headerPanel.getBounds();
                Rectangle viewportBounds = viewport.getBounds();
                if (headerPanelBounds.y + headerPanelBounds.height > viewportBounds.height) {
                    viewport.setViewPosition(headerPanel.getLocation());
                }
            }

            public void headerCollapsed(HeaderEvent event) {
            }
        });
    }

    private void configure(final Header header, String text) {
        ScrollToVisibleFocusListeners.addScrollToVisibleFocusListener((Component)header, true);
        header.setText(text != null ? text : "");
        header.setExpandable(true);
        header.setLevel(Header.Level.SUB);
        header.addHeaderListener(new HeaderListener(){

            public void headerExpanded(HeaderEvent event) {
                VerticalCategoryCollection.this.userSelectedCategories.userSelected(header.getText());
            }

            public void headerCollapsed(HeaderEvent event) {
                VerticalCategoryCollection.this.userSelectedCategories.userUnselected(header.getText());
            }
        });
    }

    HeaderPanel<JComponent> categoryPanel(String title) {
        return this.categoryHeaderMap.get(title);
    }

    @Override
    public String currentCategory() {
        return this.currentCategory;
    }

    @Override
    public void currentCategory(String newValue) {
        this.currentCategory = newValue;
        this.currentCategoryUpdated(this.currentCategory);
    }

    @Override
    public void clearCurrentCategory() {
        this.currentCategory(null);
    }

    @Override
    public JComponent gui() {
        return this.scrollPane;
    }

    @Override
    public boolean findText(String searchText, boolean searchForward, boolean searchRepeat) {
        boolean clearSearchResults = false;
        int categoryCount = this.categoryHeaders.size();
        SearchIterator iter = new SearchIterator(searchForward, this.lastCategoryInSearch, categoryCount);
        while (iter.hasNext()) {
            this.lastCategoryInSearch = iter.next();
            HeaderPanel<JComponent> panel = this.categoryHeaders.get(this.lastCategoryInSearch);
            JComponent c = panel.getHostedComponent();
            if (clearSearchResults) {
                this.findTextInComponent(c, "", searchForward, false);
            }
            if (this.findTextInComponent(c, searchText, searchForward, searchRepeat)) {
                Header header = panel.getHeader();
                if (!header.isExpanded()) {
                    header.setExpanded(true);
                }
                return true;
            }
            clearSearchResults = true;
        }
        return false;
    }

    @Override
    public int categoryCount() {
        return this.categoryHeaderMap.size();
    }

    @Override
    public String selectedCategoryName() {
        return null;
    }

    @Override
    public void selectedCategoryName(String categoryName) {
    }

    @Override
    public void additionalTabPages(Component[] additionalPages) {
        this.removeAdditionalPages();
        this.checkIfAdditionalTabPanelAdded();
        this.additionalPages = additionalPages;
        this.resetConstraints(this.additionalTabConstraints);
        if (additionalPages == null || additionalPages.length == 0) {
            return;
        }
        for (Component page : additionalPages) {
            if (!(page instanceof JComponent)) continue;
            if (page instanceof AbstractAdditionalPage) {
                AbstractAdditionalPage additionalPage = (AbstractAdditionalPage)page;
                additionalPage.render(Orientation.VERTICAL);
            }
            this.addCategory(this.additionalTabPanel, this.labelFromPage(page), (JComponent)page, this.additionalTabConstraints);
        }
    }

    private void checkIfAdditionalTabPanelAdded() {
        Container parent = SwingUtilities.getAncestorOfClass(this.getClass(), this.additionalTabPanel);
        if (parent == null) {
            this.addComponent(this, this.additionalTabPanel, this.constraints);
        }
    }

    private void addCategory(Container parent, String title, JComponent category, GridBagConstraints c) {
        category.setVisible(false);
        HeaderPanel<JComponent> headerPanel = this.createHeaderPanel(category);
        headerPanel.setAnimationEnabled(false);
        this.configure(headerPanel.getHeader(), title);
        this.addCategoryUI(parent, title, headerPanel, c);
        boolean wasExpanded = this.userSelectedCategories.isSelected(title);
        headerPanel.getHeader().setExpanded(wasExpanded);
        category.setVisible(true);
        headerPanel.setAnimationEnabled(true);
    }

    private HeaderPanel<JComponent> createHeaderPanel(JComponent categoryPanel) {
        HeaderPanel headerPanel = new HeaderPanel(categoryPanel, true);
        this.setBackgroundOf((HeaderPanel<JComponent>)headerPanel);
        categoryPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        return headerPanel;
    }

    private void setBackgroundOf(HeaderPanel<JComponent> headerPanel) {
        Color background = this.getBackground();
        headerPanel.setBackground(background);
        headerPanel.getHostedComponent().setBackground(background);
    }

    private void addCategoryUI(Container parent, String title, HeaderPanel<JComponent> categoryPanel, GridBagConstraints c) {
        this.categoryHeaderMap.put(title, categoryPanel);
        this.categoryHeaders.add(categoryPanel);
        this.addComponent(parent, (Component)categoryPanel, c);
    }

    private void addComponent(Container parent, Component component, GridBagConstraints c) {
        if (c.gridy != 0) {
            this.add(Box.createVerticalStrut(7), c);
            ++c.gridy;
        }
        parent.add(component, c);
        ++c.gridy;
    }

    @Override
    public Component[] additionalPages() {
        return this.additionalPages;
    }

    private String labelFromPage(Component page) {
        if (page instanceof Displayable) {
            return ((Displayable)page).getShortLabel();
        }
        return page.getName();
    }

    @Override
    public void removeAdditionalPages() {
        if (this.additionalPages == null || this.additionalPages.length == 0) {
            return;
        }
        for (Component additionalPage : this.additionalPages) {
            Container parent = SwingUtilities.getAncestorOfClass(HeaderPanel.class, additionalPage);
            if (parent == null) continue;
            HeaderPanel header = (HeaderPanel)parent;
            this.categoryHeaders.remove(header);
            String titleToRemove = null;
            for (Map.Entry<String, HeaderPanel<JComponent>> entry : this.categoryHeaderMap.entrySet()) {
                if (entry.getValue() != header) continue;
                titleToRemove = entry.getKey();
                break;
            }
            if (titleToRemove == null) continue;
            this.categoryHeaderMap.remove(titleToRemove);
        }
        this.additionalTabPanel.removeAll();
        this.additionalPages = NO_ADDITIONAL_PAGES;
    }

    @Override
    public Component componentToAddToPI(Properties properties) {
        if (this.categoryHeaders.size() == 1) {
            this.renderAndSelectFirstCategoryIfOnlyOne(properties);
            HeaderPanel<JComponent> headerPanel = this.categoryHeaders.get(0);
            headerPanel.getHeader().setExpanded(true);
            JComponent hosted = headerPanel.getHostedComponent();
            this.removeAll();
            this.resetConstraints(this.constraints);
            this.add(Box.createVerticalStrut(2), this.constraints);
            ++this.constraints.gridy;
            this.add((Component)hosted, this.constraints);
        }
        return this.gui();
    }

    private void renderAndSelectFirstCategoryIfOnlyOne(Properties properties) {
        PropertyCategoryPanel firstCategoryPanel = this.categoryPanels.get(0);
        if (!firstCategoryPanel.isRendered()) {
            firstCategoryPanel.render(properties, Orientation.VERTICAL);
        }
        this.userSelectedCategories.userSelected(firstCategoryPanel.categoryTitle());
    }

    private static void configure(JScrollPane scrollPane) {
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        if (verticalScrollBar != null) {
            verticalScrollBar.setUnitIncrement(20);
        }
    }

    @Override
    public boolean hasCategory(String category) {
        return this.categoryHeaderMap.containsKey(category);
    }

    @Override
    public void removeAllCategories() {
        this.removeAll();
        this.categoryHeaderMap.clear();
        this.categoryPanels.clear();
        this.categoryHeaders.clear();
        this.resetConstraints(this.constraints);
    }

    @Override
    public void updateComplete(Properties properties) {
        this.constraints.gridy = -1;
        this.constraints.fill = 1;
        this.constraints.gridheight = 0;
        this.constraints.gridwidth = 0;
        this.constraints.weighty = 1.0;
        this.add(this.endGlue, this.constraints);
        this.resetConstraints(this.constraints);
    }

    @Override
    public Color background() {
        return this.getBackground();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.additionalTabPanel != null) {
            this.additionalTabPanel.setBackground(bg);
        }
    }

    @Override
    public String defaultSelectedCategory() {
        return this.categoryPanelHelper.defaultSelectedCategory(this.categoryPanels);
    }

    public String[] defaultExpandedCategories() {
        List<String> categories = this.categoryPanelHelper.defaultExpandedCategories(this.categoryPanels);
        return categories.toArray(new String[categories.size()]);
    }

    @Override
    public void expandCategories(String[] categoryNames) {
        block0: for (HeaderPanel<JComponent> panel : this.categoryHeaders) {
            if (!panel.getHeader().isExpandable() || panel.getHeader().isExpanded()) continue;
            for (String categoryToBeExpanded : categoryNames) {
                if (!categoryToBeExpanded.equals(panel.getHeader().getText())) continue;
                panel.getHeader().setExpanded(true);
                continue block0;
            }
        }
    }
}

