/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentFactoryRegistry;
import oracle.bali.inspector.editor.EditorComponentSetupRegistry;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.ide.inspector.ConflictingValues;
import oracle.ide.inspector.CustomEditorButton;
import oracle.ide.inspector.CustomEditors;
import oracle.ide.inspector.DisplayValues;
import oracle.ide.inspector.EditorContainer;
import oracle.ide.inspector.LabelAndEditor;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.PropertyEditorUpdater;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.ScrollToVisibleFocusListeners;
import oracle.ide.inspector.SingletonPropertyEditorFinder;
import oracle.ide.inspector.UpdateComponentWithFocusListener;
import oracle.ide.inspector.ValidationIssues;
import oracle.javatools.util.ModelUtil;

public class SingletonPropertyEditorUpdater
implements PropertyEditorUpdater {
    private EditorComponentFactoryRegistry factoryRegistry = EditorComponentFactoryRegistry.instance();

    private static boolean hasFocus(Component c) {
        if (!(c instanceof JComboBox)) {
            return c.hasFocus();
        }
        JComboBox comboBox = (JComboBox)c;
        if (!comboBox.isEditable()) {
            return c.hasFocus();
        }
        ComboBoxEditor comboBoxEditor = comboBox.getEditor();
        if (comboBoxEditor == null) {
            return c.hasFocus();
        }
        Component editor = comboBoxEditor.getEditorComponent();
        if (editor == null) {
            return c.hasFocus();
        }
        return editor.hasFocus();
    }

    @Override
    public LabelAndEditor update(LabelAndEditor current, PropertyInfo property, Orientation orientation) {
        EditorContainer editorContainer = current.editorContainer();
        Component currentEditor = editorContainer.editor();
        if (property.editorFactory() == null) {
            return null;
        }
        Component realEditor = this.findEditor(currentEditor, property);
        if (realEditor == null) {
            CustomEditorButton newCustomEditorButton;
            CustomEditorButton currentCustomEditorButton = editorContainer.customEditorButton();
            EditorContainer newEditor = SingletonPropertyEditorFinder.instance().editor(property, orientation);
            current.updateWith(newEditor);
            if (SingletonPropertyEditorUpdater.hasFocus(currentEditor)) {
                newEditor.editor().requestFocusInWindow();
            }
            if (currentCustomEditorButton != null && currentCustomEditorButton.hasFocus() && (newCustomEditorButton = newEditor.customEditorButton()) != null) {
                newCustomEditorButton.requestFocusInWindow();
            }
            ScrollToVisibleFocusListeners.addScrollToVisibleFocusAdapter(current);
            this.makeAccessible(current, property);
            current.addActionsAndHelpPopupListener(property);
            return current;
        }
        this.updateLabelText(current, property);
        Component newInlineEditor = DisplayValues.truncateDisplayValue(realEditor, property);
        if (newInlineEditor == realEditor) {
            DisplayValues.showDisplayValueInInlineEditor(realEditor, property);
        } else {
            realEditor = newInlineEditor;
        }
        ConflictingValues.showConflictingValue(realEditor, property);
        this.setupEditor(editorContainer, realEditor, property, orientation);
        current.addActionsAndHelpPopupListener(property);
        return current;
    }

    private void updateLabelText(LabelAndEditor current, PropertyInfo property) {
        JLabel label = current.labelContainer().label();
        if (label == null) {
            return;
        }
        String displayName = LabelAndEditor.textForLabel(property);
        if (!ModelUtil.areEqual((Object)displayName, (Object)label.getText())) {
            label.setText(displayName);
        }
        LabelAndEditor.makeAccessible(label, current.editorContainer(), property);
    }

    private void makeAccessible(LabelAndEditor current, PropertyInfo property) {
        JLabel label = current.labelContainer().label();
        LabelAndEditor.makeAccessible(label, current.editorContainer(), property);
    }

    private Component findEditor(Component currentEditor, PropertyInfo property) {
        PropertyEditorFactory2 inspectorPropertyEditor = property.editorFactory();
        if (inspectorPropertyEditor.isPaintable()) {
            return this.factoryRegistry.updatePaintableEditor(currentEditor, inspectorPropertyEditor, property.writable());
        }
        if (inspectorPropertyEditor.hasInlineEditor() && property.writable()) {
            inspectorPropertyEditor.setPropertyValueApplier((PropertyValueApplier)property);
            Component editor = this.factoryRegistry.updateInlineEditor(currentEditor, inspectorPropertyEditor);
            if (editor != null) {
                this.configure(editor, (PropertyValueApplier)property, inspectorPropertyEditor);
            }
            return editor;
        }
        return this.factoryRegistry.updateReadOnlyEditor(currentEditor, inspectorPropertyEditor);
    }

    private void configure(Component editor, PropertyValueApplier property, PropertyEditorFactory2 inspectorPropertyEditor) {
        EditorComponentSetupRegistry.instance().configure(editor, property, inspectorPropertyEditor);
    }

    private void setupEditor(EditorContainer editorContainer, Component editor, PropertyInfo property, Orientation orientation) {
        ValidationIssues.addValidationIssues(editor, property, orientation);
        UpdateComponentWithFocusListener.addUpdateComponentWithFocusListener(property, editor);
        this.editorWithCustomEditor(property, editorContainer, editor);
    }

    private void editorWithCustomEditor(PropertyInfo property, EditorContainer editorContainer, Component editor) {
        if (!property.writable()) {
            return;
        }
        CustomEditorButton button = editorContainer.customEditorButton();
        if (button == null) {
            return;
        }
        CustomEditors.updateCustomEditor(button, property, editor);
    }

    static SingletonPropertyEditorUpdater instance() {
        return SingletonHolder.instance;
    }

    private SingletonPropertyEditorUpdater() {
    }

    private static class SingletonHolder {
        static SingletonPropertyEditorUpdater instance = new SingletonPropertyEditorUpdater();

        private SingletonHolder() {
        }
    }
}

