/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.editor.PropertyModelValueApplier;
import oracle.bali.inspector.editor.SinglePropertyInfo;
import oracle.ide.inspector.LabelAndEditor;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyDisplay;
import oracle.ide.inspector.PropertyEditorInfo;
import oracle.ide.inspector.RenderingOptimizer;
import oracle.ide.inspector.RenderingUtils;
import oracle.ide.inspector.ValueApplierPropertyChangeListener;
import oracle.javatools.status.Issue;
import oracle.javatools.util.ModelUtil;

public final class PropertyInfo
extends PropertyModelValueApplier
implements SinglePropertyInfo {
    final int row;
    private RenderingOptimizer renderingOptimizer;
    private PropertyDisplay propertyDisplay;
    private PropertyModel model;
    private String displayName;
    private Properties properties;
    private Object modelValueMirror;
    private PropertyEditorFactory2 editorFactory;
    private ValueApplierPropertyChangeListener propertyChangeListener;
    private String propertyIdAsString;

    PropertyInfo(PropertyModel model, int row, RenderingOptimizer renderingOptimizer, PropertyDisplay propertyDisplay) {
        this.model = model;
        this.row = row;
        this.renderingOptimizer = renderingOptimizer;
        this.propertyDisplay = propertyDisplay;
        this.modelValueMirror = this.value();
        this.displayName = this.displayNameFromModel();
    }

    void updatePropertyId(String newValue) {
        this.propertyIdAsString = newValue;
    }

    void update(PropertyModel model) {
        this.detachFromPropertyEditor();
        this.model = model;
        this.displayName = this.displayNameFromModel();
        this.modelValueMirror = this.value();
    }

    private String displayNameFromModel() {
        String displayName = this.model.getPropertyDisplayName(this.row);
        if (displayName == null) {
            displayName = "";
        }
        return displayName;
    }

    PropertyModel model() {
        return this.model;
    }

    Object dataFromModel(Object columnId) {
        return this.model.getData(columnId, this.row);
    }

    void partOf(Properties properties) {
        this.properties = properties;
    }

    void rendered() {
        if (this.properties == null) {
            return;
        }
        this.properties.rendered(this);
    }

    void addPropertyEditorInfo(LabelAndEditor labelAndEditor, Container iconContainer) {
        PropertyEditorInfo info = new PropertyEditorInfo(this.propertyIdAsString, labelAndEditor, iconContainer, this.row);
        this.renderingOptimizer.addPropertyEditorInfo(info);
    }

    PropertyEditorFactory2 editorFactory() {
        return this.editorFactory;
    }

    void updateEditorFactory(PropertyEditorFactory2 editorFactory) {
        this.detachFromPropertyEditor();
        this.editorFactory = editorFactory;
        if (this.editorFactory == null) {
            return;
        }
        Object value = this.value();
        try {
            editorFactory.setValue(value);
        }
        catch (Exception e) {
            String msg = "Exception updating property editor for property '" + this.displayName() + "': " + e.getMessage() + ". Stack trace:";
        }
    }

    private void detachFromPropertyEditor() {
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.detach();
        }
    }

    void attachToPropertyEditor(PropertyEditorFactory2 propertyEditor, Component editor) {
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.detach();
            this.propertyChangeListener.attachTo(propertyEditor, editor);
            return;
        }
        this.propertyChangeListener = new ValueApplierPropertyChangeListener(this, propertyEditor, editor);
    }

    void dispose() {
        this.detachFromPropertyEditor();
    }

    void updateComponentWithFocus(Component c, PropertyEditorFactory2 f) {
        this.renderingOptimizer.updateComponentWithFocus(c, f);
    }

    FocusListener updatePropertyDescriptionFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (PropertyInfo.this.propertyDisplay == null) {
                    return;
                }
                try {
                    String propertyDescription = PropertyInfo.this.model.getPropertyDescription(PropertyInfo.this.row);
                    PropertyInfo.this.propertyDisplay.showPropertyDescription(propertyDescription);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (PropertyInfo.this.propertyDisplay == null) {
                    return;
                }
                PropertyInfo.this.propertyDisplay.showPropertyDescription(null);
            }
        };
    }

    String displayName() {
        return this.displayName;
    }

    public Object displayValue() {
        return this.model.getPropertyDisplayValue(this.row);
    }

    protected Object value() {
        return this.model.getPropertyValue(this.row);
    }

    boolean writable() {
        return this.model.isPropertyWritable(this.row);
    }

    boolean hidden() {
        return this.model.getBooleanData(PropertyModel.COLUMN_IS_HIDDEN, this.row);
    }

    boolean isMandatory() {
        return this.model.isMandatory(this.row);
    }

    boolean isExpert() {
        return this.model.getBooleanData(PropertyModel.COLUMN_IS_EXPERT, this.row);
    }

    Object id() {
        return this.model.getPropertyID(this.row);
    }

    boolean isValueConflicting() {
        return this.model.isDataConflicting(this.model.getColumnIndex(PropertyModel.COLUMN_VALUE), this.row);
    }

    boolean isMatchingPropertyId(Object propertyId) {
        if (propertyId == null) {
            return false;
        }
        return this.model.isMatchingPropertyID(propertyId, this.row);
    }

    void updateModelValue(Object newValue) {
        try {
            if (this.alreadyUpdated(newValue)) {
                return;
            }
            this.modelValueMirror = newValue;
            this.model.setPropertyValue(this.row, this.modelValueMirror);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean alreadyUpdated(Object newValue) {
        if (ModelUtil.areEqual((Object)this.value(), (Object)newValue)) {
            return true;
        }
        return ModelUtil.areEqual((Object)this.modelValueMirror, (Object)newValue);
    }

    public void apply(Object newValue) {
        try {
            this.model.setPropertyValue(this.row, newValue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    Container iconContainer() {
        Container container = RenderingUtils.emptyContainer();
        Icon icon = this.icon();
        if (icon != null) {
            JLabel label = new JLabel(icon);
            String tooltip = this.model.getIconToolTip(this.row);
            if (tooltip != null && tooltip.length() > 0) {
                label.setToolTipText(tooltip);
            }
            container.add(label);
        } else {
            RenderingUtils.addEmptyIconContainerTo(container);
        }
        return container;
    }

    Icon icon() {
        return this.model.getIcon(this.row);
    }

    List<ActionGroup> actionGroups() {
        return this.model.getActionGroups(this.row);
    }

    boolean hasActionGroups() {
        List<ActionGroup> actionGroups = this.actionGroups();
        return actionGroups != null && !actionGroups.isEmpty();
    }

    Collection<? extends Issue> validationIssues() {
        Object data = this.model.getData(PropertyModel.COLUMN_VALIDATION_ISSUES, this.row);
        if (!(data instanceof Collection)) {
            return Collections.emptyList();
        }
        return (Collection)data;
    }

    public String toString() {
        if (this.displayName == null) {
            return null;
        }
        return "'" + this.displayName + "'";
    }

    public PropertyEditorFactory2 getPropertyEditorFactory() {
        return this.editorFactory();
    }

    public PropertyModel getPropertyModel() {
        return this.model;
    }

    public int getPropertyModelRow() {
        return this.row;
    }
}

