/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.MultiObjectModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.ide.inspector.PropertyDisplay;
import oracle.ide.inspector.PropertyGroupNode;
import oracle.ide.inspector.PropertyIds;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.RenderingOptimizer;
import oracle.ide.inspector.layout.CategoryLayout;
import oracle.ide.inspector.layout.CustomComponent;
import oracle.ide.inspector.layout.CustomGUIComponent;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.Property;

final class Properties
implements Iterable<PropertyInfo> {
    static final List<PropertyInfo> NO_PROPERTIES = Collections.emptyList();
    private final List<PropertyInfo> properties = new ArrayList<PropertyInfo>();
    private final Map<Object, PropertyInfo> notRenderedMap = new LinkedHashMap<Object, PropertyInfo>();
    private final Map<String, PropertyInfo> propertiesById = new HashMap<String, PropertyInfo>();
    private final Map<Integer, PropertyInfo> propertiesByIndex = new HashMap<Integer, PropertyInfo>();
    private final Map<String, List<PropertyInfo>> propertiesByGroup = new HashMap<String, List<PropertyInfo>>();
    private final Map<String, Integer> elementCountByCategory = new HashMap<String, Integer>();
    private PropertyModel model;
    private RenderingOptimizer renderingOptimizer;
    private boolean multiSelect;
    private boolean homogeneousMultiSelect;
    private boolean hasCustomComponents;

    private Properties(PropertyModel model, List<PropertyInfo> properties, RenderingOptimizer renderingOptimizer) {
        this.setModel(model);
        this.renderingOptimizer = renderingOptimizer;
        this.properties.addAll(properties);
    }

    Properties(PropertyModel model, RenderingOptimizer renderingOptimizer, PropertyDisplay descriptionDisplay) {
        this.setModel(model);
        this.renderingOptimizer = renderingOptimizer;
        if (model == null) {
            return;
        }
        this.createProperties(renderingOptimizer, descriptionDisplay);
    }

    Properties(PropertyModel model, PropertyGroup group, RenderingOptimizer renderingOptimizer, PropertyDisplay propertyDisplay) {
        this.setModel(model);
        this.renderingOptimizer = renderingOptimizer;
        if (model == null) {
            return;
        }
        this.createProperties(group, renderingOptimizer, propertyDisplay);
    }

    void update(PropertyModel model, RenderingOptimizer renderingOptimizer) {
        this.clear();
        this.setModel(model);
        this.renderingOptimizer = renderingOptimizer;
        for (PropertyInfo property : this.properties) {
            property.update(model);
            PropertyEditorFactory2 editorFactory = this.editorFactory(model, property.row);
            property.updateEditorFactory(editorFactory);
        }
    }

    void clear() {
        this.setModel(null);
        this.notRenderedMap.clear();
        this.elementCountByCategory.clear();
    }

    boolean isMultiSelect() {
        return this.multiSelect;
    }

    boolean isHomogeneousMultiSelect() {
        return this.homogeneousMultiSelect;
    }

    private boolean isMultiSelect(Object model) {
        SelectionModel selectionModel;
        PropertyModel propertyModel;
        if (model == null) {
            return false;
        }
        if (model instanceof PropertyModel && (propertyModel = (PropertyModel)model).useUnion()) {
            return false;
        }
        if (model instanceof SelectionModel) {
            selectionModel = (SelectionModel)model;
            int selectionCount = selectionModel.getSelectedItemCount();
            if (selectionCount == 0) {
                return false;
            }
            if (selectionCount > 1) {
                this.homogeneousMultiSelect = this.isHomogeneousMultiSelect(selectionModel);
                return true;
            }
            Object selection = selectionModel.getSelectedItem(0);
            if (selection instanceof PropertyModel || selection instanceof SelectionModel) {
                return this.isMultiSelect(selection);
            }
            return false;
        }
        if (model instanceof MultiObjectModel) {
            selectionModel = ((MultiObjectModel)model).getSelectionModel();
            return this.isMultiSelect(selectionModel);
        }
        return false;
    }

    private boolean isHomogeneousMultiSelect(SelectionModel model) {
        if (model == null) {
            return false;
        }
        int selectionCount = model.getSelectedItemCount();
        PropertyIds ids = null;
        int startingIndex = -1;
        for (int i = 0; i < selectionCount; ++i) {
            Object selection = model.getSelectedItem(i);
            if (!(selection instanceof PropertyModel)) continue;
            startingIndex = -1;
            ids = new PropertyIds();
            ids.update((PropertyModel)selection);
            break;
        }
        if (ids == null) {
            return false;
        }
        if (startingIndex == selectionCount - 1) {
            return false;
        }
        boolean matching = true;
        boolean atLeastOnePropertyModel = false;
        for (int i = startingIndex + 1; i < selectionCount; ++i) {
            Object selection = model.getSelectedItem(i);
            if (!(selection instanceof PropertyModel)) continue;
            atLeastOnePropertyModel = true;
            PropertyModel m = (PropertyModel)selection;
            if (ids.isMatching(m)) continue;
            matching = false;
        }
        if (!atLeastOnePropertyModel) {
            return false;
        }
        return matching;
    }

    void dispose() {
        for (PropertyInfo property : this.properties) {
            property.dispose();
        }
        this.properties.clear();
        this.notRenderedMap.clear();
        this.propertiesById.clear();
        this.propertiesByIndex.clear();
        this.propertiesByGroup.clear();
        this.elementCountByCategory.clear();
        this.setModel(null);
        this.renderingOptimizer = null;
    }

    private void setModel(PropertyModel model) {
        this.model = model;
        this.homogeneousMultiSelect = false;
        this.multiSelect = this.isMultiSelect(this.model);
    }

    PropertyInfo propertyById(String id) {
        if (this.propertiesById.containsKey(id)) {
            return this.propertiesById.get(id);
        }
        for (PropertyInfo property : this.properties) {
            if (!property.isMatchingPropertyId(id)) continue;
            this.propertiesById.put(id, property);
            return property;
        }
        return null;
    }

    PropertyInfo propertyByIndex(int index) {
        return this.propertiesByIndex.get(index);
    }

    List<String> organizeByGroups() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (PropertyInfo property : this.properties) {
            PropertyGroup propertyGroup = this.model.getPropertyGroup(property.row);
            String group = new PropertyGroupNode(propertyGroup).getName();
            if (!this.propertiesByGroup.containsKey(group)) {
                this.propertiesByGroup.put(group, new ArrayList());
            }
            this.propertiesByGroup.get(group).add(property);
            if (groupNames.contains(group)) continue;
            groupNames.add(group);
        }
        if (groupNames.size() > 1) {
            Collections.sort(groupNames);
        }
        return groupNames;
    }

    Properties propertiesInGroup(String group) {
        if (!this.propertiesByGroup.containsKey(group)) {
            return null;
        }
        return new Properties(this.model, this.propertiesByGroup.get(group), this.renderingOptimizer);
    }

    PropertyModel model() {
        return this.model;
    }

    boolean isEmpty() {
        if (!this.properties.isEmpty()) {
            return false;
        }
        int totalCategories = 0;
        for (Integer i : this.elementCountByCategory.values()) {
            if (i == null) continue;
            totalCategories += i.intValue();
        }
        if (totalCategories == 0) {
            return !this.hasCustomComponents;
        }
        return false;
    }

    PropertyInfo getFirst() {
        return this.properties.get(0);
    }

    Properties notRendered() {
        ArrayList<PropertyInfo> notRendered = new ArrayList<PropertyInfo>();
        for (Map.Entry<Object, PropertyInfo> entry : this.notRenderedMap.entrySet()) {
            notRendered.add(entry.getValue());
        }
        return new Properties(this.model, notRendered, this.renderingOptimizer);
    }

    void updateCustomComponent(CustomGUIComponent c) {
        this.renderingOptimizer.addCustomGuiComponent(c);
    }

    void updateCustomComponent(Container customComponentContainer, Component customComponent, Container labelContainer) {
        this.renderingOptimizer.addCustomComponent(customComponentContainer, customComponent, labelContainer);
    }

    @Override
    public Iterator<PropertyInfo> iterator() {
        return this.properties.iterator();
    }

    void rendered(PropertyInfo property) {
        this.notRenderedMap.remove(property.id());
    }

    private void createProperties(RenderingOptimizer renderingOptimizer, PropertyDisplay propertyDisplay) {
        int rows = this.model.getRowCount();
        for (int row = 0; row < rows; ++row) {
            this.addProperty(this.property(null, row, renderingOptimizer, propertyDisplay));
        }
    }

    private void createProperties(PropertyGroup group, RenderingOptimizer renderingOptimizer, PropertyDisplay propertyDisplay) {
        int rows = this.model.getRowCount();
        for (int row = 0; row < rows; ++row) {
            this.addProperty(this.property(group, row, renderingOptimizer, propertyDisplay));
        }
    }

    private void addProperty(PropertyInfo property) {
        if (property == null) {
            return;
        }
        this.properties.add(property);
        this.propertiesByIndex.put(property.row, property);
        this.notRenderedMap.put(property.id(), property);
        property.partOf(this);
    }

    private PropertyInfo property(PropertyGroup group, int row, RenderingOptimizer renderingOptimizer, PropertyDisplay propertyDisplay) {
        if (this.isMultiSelect() && !this.model.isPropertyCommon(row)) {
            return null;
        }
        PropertyEditorFactory2 editorFactory = this.editorFactory(this.model, row);
        if (editorFactory == null) {
            return null;
        }
        if (group != null && !group.equals(this.model.getPropertyGroup(row))) {
            return null;
        }
        PropertyInfo property = new PropertyInfo(this.model, row, renderingOptimizer, propertyDisplay);
        if (property.hidden()) {
            return null;
        }
        if (property.displayName().length() == 0) {
            return null;
        }
        property.updateEditorFactory(editorFactory);
        return property;
    }

    private PropertyEditorFactory2 editorFactory(PropertyModel model, int row) {
        PropertyEditorFactory2 editorFactory2 = model.getPropertyEditorFactory2(row);
        if (editorFactory2 != null) {
            return editorFactory2;
        }
        PropertyEditorFactory editorFactory = model.getPropertyEditorFactory(row);
        if (editorFactory instanceof PropertyEditorFactory2) {
            return (PropertyEditorFactory2)editorFactory;
        }
        PropertyEditor javaBeansPropertyEditor = null;
        if (editorFactory instanceof PropertyEditorAdapter) {
            javaBeansPropertyEditor = ((PropertyEditorAdapter)editorFactory).getPropertyEditor();
        }
        if (javaBeansPropertyEditor != null) {
            return new JavaBeansPropertyEditorAdapter(javaBeansPropertyEditor);
        }
        return null;
    }

    void tagWith(CategoryLayout category) {
        String categoryId = category.getID();
        int propertyCount = this.elementCountByCategory(categoryId);
        this.elementCountByCategory.put(categoryId, propertyCount += this.taggedWith(category));
    }

    int elementCountByCategory(String categoryId) {
        if (this.elementCountByCategory.containsKey(categoryId)) {
            return this.elementCountByCategory.get(categoryId);
        }
        return 0;
    }

    int taggedWith(Element element) {
        int propertyCount = 0;
        for (Element e : element.getChildren()) {
            if (e instanceof Property) {
                if (!this.tagProperty((Property)e)) continue;
                ++propertyCount;
                continue;
            }
            if (e instanceof CustomComponent) {
                CustomComponent c = (CustomComponent)e;
                CustomGUIComponent component = c.getComponent();
                if (!component.hasContent()) continue;
                ++propertyCount;
                continue;
            }
            propertyCount += this.taggedWith(e);
        }
        return propertyCount;
    }

    private boolean tagProperty(Property property) {
        String id = property.getID();
        Object realId = this.model.getMatchingId((Object)id);
        if (realId == null) {
            return false;
        }
        PropertyInfo p = this.notRenderedMap.get(realId);
        if (p == null) {
            return false;
        }
        p.rendered();
        p.updatePropertyId(id);
        this.propertiesById.put(id, p);
        return true;
    }

    void sort() {
        if (this.properties.size() <= 1) {
            return;
        }
        Collections.sort(this.properties, new Comparator<PropertyInfo>(){

            @Override
            public int compare(PropertyInfo p1, PropertyInfo p2) {
                Locale locale = Locale.getDefault();
                String name1 = p1.displayName();
                String name2 = p2.displayName();
                int ret = name1.toLowerCase(locale).compareTo(name2.toLowerCase(locale));
                return ret != 0 ? ret : name1.compareTo(name2);
            }
        });
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!this.properties.isEmpty()) {
            b.append("Properties: ");
            b.append("\n");
        }
        for (PropertyInfo p : this.properties) {
            b.append((Object)p);
            b.append("\n");
        }
        b.append(this.properties.size() + " properties");
        return b.toString();
    }

    void thereIsCustomComponents() {
        this.hasCustomComponents = true;
    }
}

