/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import oracle.bali.inspector.ActionContext;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.editor.SinglePropertyInfo;
import oracle.ide.inspector.ContextActionPanelHost;
import oracle.ide.inspector.CustomEditors;

public class LazyLoadMenuButton
extends JButton {
    private SinglePropertyInfo property;
    private String name;
    private ActionContext context;

    LazyLoadMenuButton(Action action, ActionContext context, SinglePropertyInfo property) {
        this.name = this.nameFrom(action);
        if (this.name == null) {
            this.name = "";
        }
        this.setText(this.name);
        this.context = context;
        this.property = property;
        this.setEnabled(action.isEnabled());
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!"enabled".equals(evt.getPropertyName())) {
                    return;
                }
                Object value = evt.getNewValue();
                if (!(value instanceof Boolean)) {
                    return;
                }
                LazyLoadMenuButton.this.setEnabled((Boolean)value);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent e) {
                Window w = SwingUtilities.getWindowAncestor(LazyLoadMenuButton.this);
                if (w instanceof ContextActionPanelHost) {
                    w.setVisible(false);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LazyLoadMenuButton.this.callRealAction(e);
                    }
                });
            }
        });
    }

    private void callRealAction(ActionEvent e) {
        List<ActionGroup> actions = CustomEditors.actionGroups(this.property);
        if (actions.isEmpty()) {
            return;
        }
        for (ActionGroup group : actions) {
            for (Action action : group) {
                if (!this.name.equals(this.nameFrom(action))) continue;
                ActionContext.updateContextIn((Action)action, (ActionContext)this.context).actionPerformed(e);
                return;
            }
        }
    }

    private String nameFrom(Action action) {
        return (String)action.getValue("Name");
    }

    private Icon iconFrom(Action action) {
        Object icon = action.getValue("SmallIcon");
        Object value = action.getValue("SwingLargeIconKey");
        if (icon instanceof Icon) {
            return (Icon)icon;
        }
        return null;
    }
}

