/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.inspector.DefaultInspectable;
import oracle.ide.inspector.IdeMultiObjectModel;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.inspector.IdePropertyModelFactory;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.InspectableFactory;
import oracle.ide.inspector.MultiInspectable;
import oracle.ide.inspector.PropertyModelFactory;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ideimpl.inspector.PIHook;

public class InspectorFactory {
    private static final InspectorFactory INSTANCE = new InspectorFactory();
    private static final String BEANINFO_PROPERTY = "Ide.BeanInfoSearchPath";
    private final Map<Class, Class> inspectableRegistry = new HashMap<Class, Class>();
    private final Map<Class, Class> modelRegistry = new HashMap<Class, Class>();
    private final List<PropertyModelFactory> propertyModelFactories = new ArrayList<PropertyModelFactory>();
    private final List<InspectableFactory> factories = new ArrayList<InspectableFactory>();
    private Class defaultInspectable = DefaultInspectable.class;
    private boolean _initializeDeclaredFactoriesDone;

    private static void updateIntrospectorBeanInfoSearchPath() {
        String path = Ide.getProperty((String)BEANINFO_PROPERTY);
        if (path == null) {
            return;
        }
        String[] paths = InspectorFactory.addInstrospectorBeanInfoSearchPathsTo(InspectorFactory.split(path));
        Introspector.setBeanInfoSearchPath(paths);
    }

    private static List<String> split(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, ";");
        ArrayList<String> paths = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            paths.add(tokenizer.nextToken());
        }
        return paths;
    }

    private static String[] addInstrospectorBeanInfoSearchPathsTo(List<String> paths) {
        String[] pathsToAdd = Introspector.getBeanInfoSearchPath();
        if (pathsToAdd != null) {
            for (String path : pathsToAdd) {
                paths.add(path);
            }
        }
        return paths.toArray(new String[paths.size()]);
    }

    public static InspectorFactory getInstance() {
        return INSTANCE;
    }

    public InspectorFactory() {
        this.register(new IdePropertyModelFactory());
    }

    public MultiInspectable getMultiInspectable(Context context) {
        return new MultiInspectable(context, this.propertyModelFactories);
    }

    public List<Inspectable> getInspectables(Context context) {
        Element e = InspectorFactory.elementFrom(context);
        if (e == null) {
            return Collections.emptyList();
        }
        this.initializeDeclaredFactories();
        return this.inspectablesFromFactories(context);
    }

    private List<Inspectable> inspectablesFromFactories(Context context) {
        ArrayList<Inspectable> inspectables = new ArrayList<Inspectable>();
        this.initializeDeclaredFactories();
        for (InspectableFactory factory : this.factories) {
            Inspectable i = factory.getInspectable(context);
            if (i == null || inspectables.contains(i)) continue;
            inspectables.add(i);
        }
        return inspectables;
    }

    public Inspectable getInspectable(Context context, Element e) {
        if (e == null) {
            return null;
        }
        Inspectable inspectable = this.inspectableFrom(InspectorFactory.targetFrom(e));
        if (inspectable == null) {
            return null;
        }
        Context copyContext = new Context(context);
        copyContext.setSelection(new Element[]{e});
        inspectable.setContext(copyContext);
        return inspectable;
    }

    private static Element elementFrom(Context context) {
        if (context == null) {
            return null;
        }
        Node e = context.getNode();
        if (e == null) {
            e = context.getElement();
        }
        return e;
    }

    private static Attributes attributesFrom(Element e) {
        return e != null ? e.getAttributes() : null;
    }

    private static boolean readOnly(Attributes a) {
        if (a == null) {
            return false;
        }
        return a.isSet(ElementAttributes.NON_EDITABLE);
    }

    private static Object targetFrom(Element e) {
        Object target = e.getData();
        if (target == null) {
            target = e;
        }
        return target;
    }

    private Inspectable inspectableFrom(Object target) {
        if (target instanceof Inspectable) {
            return (Inspectable)target;
        }
        Class<?> targetType = target.getClass();
        Class inspectableType = InspectorFactory.inspectableTypeFrom(targetType, this.inspectableRegistry);
        return this.newInspectable(inspectableType);
    }

    private static Class inspectableTypeFrom(Class targetType, Map<Class, Class> inspectableRegistry) {
        Class inspectableType = inspectableRegistry.get(targetType);
        while (inspectableType == null && (inspectableType = InspectorFactory.interfaceFromRegistry(targetType, inspectableRegistry)) == null && (targetType = targetType.getSuperclass()) != null) {
            inspectableType = inspectableRegistry.get(targetType);
        }
        return inspectableType;
    }

    private static Class interfaceFromRegistry(Class targetType, Map<Class, Class> inspectableRegistry) {
        Class<?>[] interfaces;
        Class<?>[] classArray = interfaces = targetType != null ? targetType.getInterfaces() : null;
        if (interfaces == null) {
            return null;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            Class type = inspectableRegistry.get(interfaces[i]);
            if (type == null) {
                type = InspectorFactory.interfaceFromRegistry(interfaces[i], inspectableRegistry);
            }
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private Inspectable newInspectable(Class type) {
        if (type == null) {
            return null;
        }
        try {
            return (Inspectable)type.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void registerInspectable(Class targetType, Class inspectableType) throws ClassCastException {
        if (targetType == null) {
            return;
        }
        if (inspectableType == null) {
            this.inspectableRegistry.remove(targetType);
            return;
        }
        if (!Inspectable.class.isAssignableFrom(inspectableType)) {
            throw new ClassCastException();
        }
        this.inspectableRegistry.put(targetType, inspectableType);
    }

    public void register(PropertyModelFactory factory) {
        this.propertyModelFactories.add(0, factory);
    }

    public void remove(PropertyModelFactory factory) {
        this.propertyModelFactories.remove(factory);
    }

    public void addInspectableFactory(InspectableFactory factory) {
        if (factory != null && !this.factories.contains(factory)) {
            this.factories.add(factory);
        }
    }

    public void removeInspectableFactory(InspectableFactory factory) {
        if (factory != null) {
            this.factories.remove(factory);
        }
    }

    public void setDefaultInspectable(Class cls) {
        if (cls != null && Inspectable.class.isAssignableFrom(cls)) {
            this.defaultInspectable = cls;
        }
    }

    public Class getPropertyModelType(Class desiredType) {
        if (desiredType == null) {
            return IdeMultiObjectModel.class;
        }
        Class propertyModelType = this.modelRegistry.get(desiredType);
        while (propertyModelType == null && (propertyModelType = InspectorFactory.interfaceFromRegistry(desiredType, this.modelRegistry)) == null && (desiredType = desiredType.getSuperclass()) != null) {
            propertyModelType = this.modelRegistry.get(desiredType);
        }
        return propertyModelType != null ? propertyModelType : IdeMultiObjectModel.class;
    }

    public void registerPropertyModel(Class targetType, Class modelType) throws ClassCastException {
        if (targetType == null) {
            return;
        }
        if (modelType == null) {
            this.modelRegistry.remove(targetType);
            return;
        }
        if (!IdePropertyModel.class.isAssignableFrom(modelType)) {
            throw new ClassCastException();
        }
        this.modelRegistry.put(targetType, modelType);
    }

    public static final BeanInfo getBeanInfo(Class beanType) throws IntrospectionException {
        return Introspector.getBeanInfo(beanType);
    }

    private void initializeDeclaredFactories() {
        if (this._initializeDeclaredFactoriesDone) {
            return;
        }
        this._initializeDeclaredFactoriesDone = true;
        PIHook hook = PIHook.getPIHook();
        if (hook == null) {
            return;
        }
        List<MetaClass> providers = hook.getInspectableFactories();
        for (MetaClass metaClass : providers) {
            try {
                this.addInspectableFactory((InspectableFactory)metaClass.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        InspectorFactory.updateIntrospectorBeanInfoSearchPath();
    }
}

