/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.view.View;
import oracle.javatools.util.ModelUtil;

public final class InspectableViewRegistry {
    private final List<String> supporters = new CopyOnWriteArrayList<String>();
    private final List<String> detractors = new CopyOnWriteArrayList<String>();

    public void registerSupporter(View view) {
        if (view == null) {
            String msg = "The supporter view to register should not be null";
            throw new IllegalArgumentException(msg);
        }
        this.registerSupporter(view.getClass());
    }

    public void registerSupporter(Class<? extends View> viewType) {
        if (viewType == null) {
            String msg = "The type of the supporter view to register should not be null";
            throw new IllegalArgumentException(msg);
        }
        this.registerSupporter(viewType.getName());
    }

    public void registerSupporter(String classFQN) {
        if (!ModelUtil.hasLength((String)classFQN)) {
            throw new IllegalArgumentException("The fully-qualified name of the supporter view to register should not be null or empty");
        }
        if (this.supporters.contains(classFQN)) {
            return;
        }
        this.supporters.add(classFQN);
    }

    public Iterable<String> supporters() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return InspectableViewRegistry.this.supporters.iterator();
            }
        };
    }

    public void registerDetractor(View view) {
        if (view != null) {
            this.registerDetractor(view.getClass());
        }
        String msg = "The detractor view to register should not be null";
        throw new IllegalArgumentException(msg);
    }

    public void registerDetractor(Class<? extends View> viewType) {
        if (viewType != null) {
            this.registerDetractor(viewType.getName());
        }
        String msg = "The type of the detractor view to register should not be null";
        throw new IllegalArgumentException(msg);
    }

    public void registerDetractor(String classFQN) {
        if (!ModelUtil.hasLength((String)classFQN)) {
            String msg = "The fully-qualified name of the detractor view to register should not be null or empty";
            throw new IllegalArgumentException(msg);
        }
        if (this.detractors.contains(classFQN)) {
            return;
        }
        this.detractors.add(classFQN);
    }

    public Iterable<String> detractors() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return InspectableViewRegistry.this.detractors.iterator();
            }
        };
    }

    public static InspectableViewRegistry instance() {
        return SingletonHolder.instance;
    }

    private InspectableViewRegistry() {
        this.supporters.add("oracle.ide.navigator.NavigatorWindow");
        this.supporters.add("oracle.ide.editor.Editor");
        this.supporters.add("oracle.ideimpl.explorer.ExplorerWindowImpl");
        this.supporters.add("oracle.ide.explorer.Explorer");
    }

    private static class SingletonHolder {
        static InspectableViewRegistry instance = new InspectableViewRegistry();

        private SingletonHolder() {
        }
    }
}

