/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import oracle.ide.inspector.CustomEditorButton;

final class EditorContainer
extends Box {
    private static final int MIN_WIDTH = 100;
    private Component editor;
    private Component space;
    private CustomEditorButton customEditorButton;

    EditorContainer(Component editor) {
        this(editor, null);
    }

    EditorContainer(Component editor, CustomEditorButton customEditorButton) {
        super(2);
        this.update(editor);
        this.customEditorButton = customEditorButton;
        this.addComponents();
    }

    private void addComponents() {
        this.add(this.editor);
        if (this.customEditorButton != null) {
            this.space = EditorContainer.createHorizontalStrut(3);
            this.add(this.space);
            this.add((Component)((Object)this.customEditorButton));
        }
    }

    Component editor() {
        return this.editor;
    }

    CustomEditorButton customEditorButton() {
        return this.customEditorButton;
    }

    void updateWith(EditorContainer editorContainer) {
        this.updateWith(editorContainer.editor(), editorContainer.customEditorButton());
    }

    void addPropertyEditorToContainer() {
        this.updateWith(this.editor(), this.customEditorButton());
    }

    void updateWith(Component editor, CustomEditorButton customEditorButton) {
        this.update(editor);
        if (this.customEditorButton != null && this.customEditorButton != customEditorButton) {
            this.customEditorButton.releaseActionContext();
        }
        this.customEditorButton = customEditorButton;
        this.removeAll();
        this.addComponents();
    }

    void clear() {
        if (this.customEditorButton != null) {
            this.customEditorButton.releaseActionContext();
        }
        this.customEditorButton = null;
        this.update((Component)null);
    }

    void update(Component editor) {
        this.editor = editor;
        if (this.editor == null) {
            return;
        }
        if (this.editor instanceof JCheckBox) {
            return;
        }
        Dimension preferred = this.editor.getPreferredSize();
        this.editor.setPreferredSize(new Dimension(5, preferred.height));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension fromSuper = super.getPreferredSize();
        if ((this.editor instanceof JTextField || this.editor instanceof JComboBox || this.editor instanceof JCheckBox) && fromSuper.width < 100) {
            fromSuper.width = 100;
        }
        return fromSuper;
    }
}

