/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import javax.swing.JTextField;
import oracle.bali.inspector.editor.EditorComponentFactoryRegistry;
import oracle.ide.inspector.PropertyInfo;

public final class DisplayValues {
    private static final int MAXIMUM_DISPLAY_VALUE_LENGTH = 300;

    public static String displayValue(PropertyInfo property) {
        Object displayValue = property.displayValue();
        if (displayValue == null) {
            return null;
        }
        return displayValue.toString();
    }

    public static void showDisplayValueInInlineEditor(Component inlineEditor, PropertyInfo property) {
        if (!(inlineEditor instanceof JTextField)) {
            return;
        }
        JTextField textEditor = (JTextField)inlineEditor;
        String text = DisplayValues.displayValue(property);
        if (text == null || text.length() == 0) {
            return;
        }
        String currentText = textEditor.getText();
        if (text.equals(currentText)) {
            return;
        }
        textEditor.setText(text);
    }

    public static Component truncateDisplayValue(Component inlineEditor, PropertyInfo property) {
        String text;
        Component newEditor;
        String displayValue;
        EditorComponentFactoryRegistry factories = EditorComponentFactoryRegistry.instance();
        if (inlineEditor instanceof JTextField && (displayValue = DisplayValues.displayValue(property)) != null && displayValue.length() > 300 && (newEditor = factories.updateReadOnlyEditor(inlineEditor, text = displayValue.substring(0, 50) + "...")) == null) {
            return factories.createReadOnlyEditor(text);
        }
        return inlineEditor;
    }

    private DisplayValues() {
    }
}

