/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.ide.view.GUIPanel;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.inspector.AbstractFormLayoutPanel;
import oracle.ide.inspector.Backgrounds;
import oracle.ide.inspector.ChoiceGroupPanel;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.RenderingUtils;
import oracle.ide.inspector.layout.ChoiceGroup;
import oracle.ide.inspector.layout.CustomComponent;
import oracle.ide.inspector.layout.CustomGUIComponent;
import oracle.ide.inspector.layout.DisplayGroup;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.Property;
import oracle.ide.inspector.layout.Row;
import oracle.ide.inspector.layout.Spring;
import oracle.javatools.util.ModelUtil;

abstract class DisplayGroupPanel
extends AbstractFormLayoutPanel {
    static final Property PLACE_HOLDER = new Property(){

        public String getID() {
            return null;
        }
    };
    static final SpringSize DEFAULT_SPRING = new SpringSize();
    static final Color HINT_FOREGROUND = new Color(102, 102, 102);
    private static final String NO_TITLE = null;
    final String title;
    final String hint;
    final Orientation orientation;
    private final List<Object> rows = new ArrayList<Object>();

    DisplayGroupPanel(DisplayGroup group, Properties properties, Orientation orientation) {
        this(group.getTitle(), group.getHint(), orientation);
        this.render(group, properties);
    }

    DisplayGroupPanel(List<Element> group, Properties properties, Orientation orientation) {
        this(NO_TITLE, null, orientation);
        this.render(group, properties);
    }

    private DisplayGroupPanel(String title, String hint, Orientation orientation) {
        this.title = title;
        this.hint = hint;
        this.orientation = orientation;
    }

    void expand() {
        this.expanded(true);
    }

    void collapse() {
        this.expanded(false);
    }

    abstract void expanded(boolean var1);

    abstract boolean isExpanded();

    final void render(DisplayGroup group, Properties properties) {
        this.initChildren(group.getChildren(), properties);
        if (this.hasTitle()) {
            this.initTargetPanelWithTitle(this.isExpanded(group));
        } else {
            this.initTargetPanelWithoutTitle();
        }
        this.render(properties);
    }

    private boolean isExpanded(DisplayGroup group) {
        return group.isExpanded();
    }

    final void render(List<Element> group, Properties properties) {
        this.initChildren(group, properties);
        this.initTargetPanelWithoutTitle();
        this.render(properties);
    }

    private void initChildren(List<Element> children, Properties properties) {
        for (Element child : children) {
            this.initChild(child, properties);
        }
    }

    private void initChild(Element child, Properties properties) {
        if (this.isProperty(child)) {
            this.add((Property)child, properties);
        } else if (this.isRow(child)) {
            this.add((Row)child, properties);
        } else if (this.isCustomComponent(child)) {
            this.add((CustomComponent)child);
        } else if (this.isChoiceGroup(child)) {
            this.add((ChoiceGroup)child);
        }
    }

    private void initTargetPanelWithoutTitle() {
        this.updateTargetPanel(this);
        this.addHint();
    }

    private void addHint() {
        if (!this.hasHint()) {
            return;
        }
        this.constraints().gridwidth = 2;
        this.constraints().weightx = 0.0;
        this.addToTargetPanel(new JLabel(this.hint));
        ++this.constraints().gridy;
    }

    private void initTargetPanelWithTitle(boolean expanded) {
        JPanel targetPanel = new JPanel(new GridBagLayout());
        this.updateTargetPanel(targetPanel);
        DisplayGroupPanel.setUpLAF(targetPanel);
        this.setUpHeader(expanded);
        this.addHintWhenHavingTitle();
        this.addTarget(targetPanel);
    }

    abstract void setUpHeader(boolean var1);

    abstract void addHintWhenHavingTitle();

    boolean hasTitle() {
        return ModelUtil.hasLength((String)this.title);
    }

    boolean hasHint() {
        return ModelUtil.hasLength((String)this.hint);
    }

    void addVerticalSpace(int space) {
        ++this.constraints().gridy;
        super.add(Box.createVerticalStrut(space), this.constraints());
    }

    private void addTarget(JPanel targetPanel) {
        this.addVerticalSpace(1);
        ++this.constraints().gridy;
        this.constraints().gridwidth = 2;
        this.add((Component)targetPanel, this.constraints());
    }

    private void add(Property property, Properties properties) {
        if (!this.visibleProperty(property, properties)) {
            return;
        }
        this.rows.add(property);
        this.updateMaxColumns(4);
    }

    private void add(Row row, Properties properties) {
        ArrayList<Object> newRow = new ArrayList<Object>();
        int columnCount = 0;
        Object previous = null;
        for (Element child : row.getChildren()) {
            if (this.isProperty(child)) {
                if (!this.visibleProperty((Property)child, properties)) continue;
                if (previous != null && !(previous instanceof SpringSize)) {
                    newRow.add(DEFAULT_SPRING);
                    ++columnCount;
                }
                newRow.add(child);
                previous = child;
                columnCount += 4;
                continue;
            }
            if (!(child instanceof Spring) || newRow.isEmpty()) continue;
            SpringSize spring = new SpringSize((Spring)child);
            newRow.add(spring);
            previous = spring;
            ++columnCount;
        }
        if (newRow.isEmpty()) {
            return;
        }
        if (this.rows.isEmpty() && this.rowWithOnePropertyAndSpringPlaceHolder(newRow)) {
            newRow.remove(newRow.size() - 1);
            newRow.add(DEFAULT_SPRING);
            newRow.add(PLACE_HOLDER);
            columnCount += 5;
        }
        this.updateMaxColumns(columnCount);
        this.rows.add(newRow);
    }

    private boolean rowWithOnePropertyAndSpringPlaceHolder(List<Object> newRow) {
        if (newRow.size() != 2) {
            return false;
        }
        if (!this.isProperty(newRow.get(0))) {
            return false;
        }
        Object mayBeSpring = newRow.get(1);
        if (!(mayBeSpring instanceof SpringSize)) {
            return false;
        }
        return mayBeSpring != DEFAULT_SPRING;
    }

    private void add(CustomComponent component) {
        this.rows.add(component);
    }

    private void add(ChoiceGroup choiceGroup) {
        this.rows.add(choiceGroup);
    }

    private void render(Properties properties) {
        int editorWidth = this.singlePropertyEditorWidth();
        for (Object o : this.rows) {
            if (!this.singlePropertyRendered(o, editorWidth, 0, properties) && !this.rowRendered(o, properties) && !this.choiceGroupRendered(o, properties) && !this.componentRendered(o, properties)) continue;
        }
        this.constraints().gridwidth = this.maxColumns();
        if (Orientation.HORIZONTAL.equals((Object)this.orientation)) {
            this.addToTargetPanel(Box.createVerticalStrut(7));
        }
    }

    private boolean singlePropertyRendered(Object o, int editorWidth, int startCell, Properties properties) {
        if (this.propertyRendered(o, editorWidth, startCell, properties, this.orientation)) {
            ++this.constraints().gridy;
            return true;
        }
        return false;
    }

    private boolean choiceGroupRendered(Object o, Properties properties) {
        if (!this.isChoiceGroup(o)) {
            return false;
        }
        ChoiceGroup choiceGroup = (ChoiceGroup)o;
        ChoiceGroupPanel panel = new ChoiceGroupPanel(choiceGroup, properties, this.orientation);
        if (panel.hasContent()) {
            panel.setBackground(this.getBackground());
            this.constraints().gridwidth = this.maxColumns();
            this.addToTargetPanel(panel);
            ++this.constraints().gridy;
        }
        return true;
    }

    private boolean componentRendered(Object o, Properties properties) {
        if (!(o instanceof CustomComponent)) {
            return false;
        }
        CustomGUIComponent guiComponent = ((CustomComponent)o).getComponent();
        if (guiComponent == null) {
            return true;
        }
        guiComponent.onInitialize(properties.model());
        if (!guiComponent.hasContent()) {
            return true;
        }
        this.addCustomComponentToPropertyInspector(guiComponent, properties);
        GUIPanel panel = guiComponent.getGUIPanel();
        Object rootComponent = panel.getRootComponent();
        if (!(rootComponent instanceof JComponent)) {
            return true;
        }
        JComponent root = (JComponent)rootComponent;
        CustomGUIComponent.setCustomGUIComponent(root, guiComponent);
        JLabel componentLabel = guiComponent.getLabel();
        root.setBackground(Backgrounds.backgroundFor(this.orientation));
        if (componentLabel == null) {
            this.renderCustomComponent(root, properties);
        } else {
            this.renderCustomComponent(componentLabel, root, properties);
        }
        Object focusable = panel.getFocusableComponent();
        if (focusable instanceof JComponent && guiComponent.shouldApplyOnLostFocus()) {
            this.addOnApplyFocusListenerTo((JComponent)focusable, guiComponent, properties);
        }
        ++this.constraints().gridy;
        return true;
    }

    private void addCustomComponentToPropertyInspector(CustomGUIComponent c, Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        properties.updateCustomComponent(c);
    }

    private void addOnApplyFocusListenerTo(JComponent c, CustomGUIComponent gui, Properties properties) {
        FocusListener[] focusListeners = c.getFocusListeners();
        PropertyModel model = properties.model();
        for (FocusListener listener : focusListeners) {
            if (!(listener instanceof OnApplyFocusListener)) continue;
            ((OnApplyFocusListener)listener).update(model, gui);
            return;
        }
        c.addFocusListener(new OnApplyFocusListener(model, gui));
    }

    private void renderCustomComponent(JComponent customComponent, Properties properties) {
        this.constraints().insets.top = 4;
        this.constraints().gridx = 0;
        this.constraints().gridwidth = this.maxColumns();
        this.constraints().anchor = 18;
        this.constraints().fill = 1;
        Container customComponentContainer = RenderingUtils.containerWith(customComponent);
        properties.updateCustomComponent(customComponentContainer, customComponent, null);
        this.addToTargetPanel(customComponentContainer);
    }

    private void renderCustomComponent(JLabel label, JComponent customComponent, Properties properties) {
        this.render(label, customComponent, this.singlePropertyEditorWidth(), 0, properties);
    }

    private boolean rowRendered(Object e, Properties properties) {
        if (!(e instanceof List)) {
            return false;
        }
        List row = (List)e;
        return this.rowRendered(row, this.propertyCount(row), properties);
    }

    private int propertyCount(List<Object> row) {
        int propertyCount = 0;
        for (int i = 0; i < row.size(); ++i) {
            Object o = row.get(i);
            if (!this.isProperty(o)) continue;
            ++propertyCount;
            if (i != row.size() - 2 || !(row.get(i + 1) instanceof SpringSize)) continue;
            ++propertyCount;
        }
        return propertyCount;
    }

    private boolean rowRendered(List<Object> row, int propertyCount, Properties properties) {
        if (propertyCount == 0) {
            return true;
        }
        if (propertyCount == 1) {
            return this.singlePropertyRowRendered(row, properties);
        }
        return this.multiplePropertyRowRendered(row, propertyCount, properties);
    }

    private boolean singlePropertyRowRendered(List<Object> row, Properties properties) {
        for (Object o : row) {
            if (this.propertyRendered(o, this.singlePropertyEditorWidth(), 0, properties, this.orientation)) break;
        }
        ++this.constraints().gridy;
        return true;
    }

    private boolean multiplePropertyRowRendered(List<Object> row, int propertyCount, Properties properties) {
        int startCell = 0;
        int renderedProperties = 0;
        for (int i = 0; i < row.size(); ++i) {
            Object o = row.get(i);
            if (this.isProperty(o)) {
                if (renderedProperties < propertyCount - 1) {
                    this.propertyRendered(o, 1, startCell, properties, this.orientation);
                    startCell += 4;
                    ++renderedProperties;
                    continue;
                }
                if (o == PLACE_HOLDER) {
                    this.resetConstraints(startCell);
                    ++this.constraints().gridx;
                    this.constraints().gridwidth = this.multiplePropertyEditorWidth(startCell);
                    this.constraints().weightx = 1.0;
                    this.constraints().fill = 1;
                    this.addToTargetPanel(new JLabel());
                    this.constraints().gridwidth = 1;
                    continue;
                }
                this.propertyRendered(o, this.multiplePropertyEditorWidth(startCell), startCell, properties, this.orientation);
                continue;
            }
            if (!(o instanceof SpringSize)) continue;
            SpringSize size = (SpringSize)o;
            ++this.constraints().gridx;
            ++startCell;
            int fill = this.constraints().fill;
            double weightx = this.constraints().weightx;
            Insets insets = this.constraints().insets;
            this.constraints().insets = new Insets(0, 0, 0, 0);
            this.constraints().fill = 0;
            this.constraints().weightx = 0.0;
            this.addToTargetPanel(size.spring());
            this.constraints().fill = fill;
            this.constraints().weightx = weightx;
            this.constraints().insets = insets;
        }
        ++this.constraints().gridy;
        return true;
    }

    private int singlePropertyEditorWidth() {
        if (this.maxColumns() > 4) {
            return this.maxColumns() - 4 + 1;
        }
        return 1;
    }

    private int multiplePropertyEditorWidth(int currentColumn) {
        return this.maxColumns() - (currentColumn + 4) + 1;
    }

    private boolean isRow(Object o) {
        return o instanceof Row;
    }

    private boolean isCustomComponent(Object o) {
        return o instanceof CustomComponent;
    }

    private boolean isChoiceGroup(Object o) {
        return o instanceof ChoiceGroup;
    }

    static class OnApplyFocusListener
    implements FocusListener {
        private PropertyModel propertyModel;
        private CustomGUIComponent guiComponent;

        public OnApplyFocusListener(PropertyModel propertyModel, CustomGUIComponent guiComponent) {
            this.update(propertyModel, guiComponent);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.guiComponent.onApply(this.propertyModel);
        }

        public void update(PropertyModel propertyModel, CustomGUIComponent guiComponent) {
            this.propertyModel = propertyModel;
            this.guiComponent = guiComponent;
        }
    }

    static class SpringSize {
        private static final int DEFAULT_MIN = 3;
        int min;
        int preferred;
        int max;

        SpringSize() {
            this.min = 3;
            this.preferred = 3;
            this.max = 3;
        }

        SpringSize(Spring spring) {
            this.min = spring.getMinimumLength();
            if (this.min <= 0) {
                this.min = 3;
            }
            this.preferred = spring.getPreferredLength();
            if (this.min > this.preferred) {
                this.preferred = this.min;
            }
            this.max = spring.getMaximumLength();
            if (this.min > this.max) {
                this.max = this.min;
            }
        }

        Component spring() {
            return new Box.Filler(this.dimension(this.min), this.dimension(this.max), this.dimension(this.preferred));
        }

        private Dimension dimension(int width) {
            return new Dimension(width, 0);
        }
    }
}

