/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.CustomEditorAction;
import oracle.bali.inspector.CustomEditorActionSource;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.editor.SinglePropertyInfo;
import oracle.ide.inspector.CustomEditorButton;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.ScrollToVisibleFocusListeners;

final class CustomEditors {
    static CustomEditorButton customEditor(PropertyInfo property, Component editor) {
        List<ActionGroup> actionGroups = CustomEditors.actionGroups(property);
        if (actionGroups.isEmpty()) {
            return null;
        }
        CustomEditorButton button = new CustomEditorButton(property, editor);
        button.setActionGroups(actionGroups);
        ScrollToVisibleFocusListeners.addScrollToVisibleFocusListener((Component)((Object)button));
        return button;
    }

    static void updateCustomEditor(CustomEditorButton button, PropertyInfo property, Component editor) {
        List<ActionGroup> actionGroups = CustomEditors.actionGroups(property);
        button.update(property.editorFactory(), property.model(), property.row, editor);
        button.setActionGroups(actionGroups);
    }

    static List<ActionGroup> actionGroups(PropertyInfo property) {
        return CustomEditors.allActionGroups(property.actionGroups(), property.editorFactory());
    }

    static List<ActionGroup> actionGroups(SinglePropertyInfo property) {
        PropertyModel model = property.getPropertyModel();
        int row = property.getPropertyModelRow();
        PropertyEditorFactory2 propertyEditor = property.getPropertyEditorFactory();
        return CustomEditors.allActionGroups(model.getActionGroups(row), propertyEditor);
    }

    private static List<ActionGroup> allActionGroups(List<ActionGroup> actionGroupsFromModel, PropertyEditorFactory2 propertyEditor) {
        ArrayList<ActionGroup> actionGroups = new ArrayList<ActionGroup>();
        ActionGroup propertyEditorActions = CustomEditors.actionGroup(propertyEditor);
        if (propertyEditorActions != null) {
            actionGroups.add(propertyEditorActions);
        }
        if (actionGroupsFromModel != null && !actionGroupsFromModel.isEmpty()) {
            actionGroups.addAll(actionGroupsFromModel);
        }
        return actionGroups;
    }

    private static ActionGroup actionGroup(PropertyEditorFactory2 propertyEditor) {
        if (propertyEditor instanceof CustomEditorActionSource) {
            return CustomEditors.actionGroup((CustomEditorActionSource)propertyEditor);
        }
        return null;
    }

    private static ActionGroup actionGroup(CustomEditorActionSource source) {
        CustomEditorAction action = source.customEditorAction();
        if (action == null) {
            return null;
        }
        return new ActionGroup((Action)action);
    }

    private CustomEditors() {
    }
}

