/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.javatools.ui.table.table;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import oracle.dmt.javatools.ui.table.table.BasicRowHeaderModel;
import oracle.dmt.javatools.ui.table.table.DefaultRowHeaderRenderer;
import oracle.dmt.javatools.ui.table.table.RolloverListener;
import oracle.dmt.javatools.ui.table.table.RolloverRowHeaderListener;
import oracle.dmt.javatools.ui.table.table.RolloverRowHeaderRenderer;
import oracle.dmt.javatools.ui.table.table.RowHeaderSelectionModel;

public class RowHeader
extends JList {
    private JTable _table;
    private TableListener _listener;
    private RolloverListener rolloverListener;
    private boolean _highlight;

    public RowHeader(JTable table) {
        super(new BasicRowHeaderModel(table.getModel()));
        this._table = table;
        this._table.putClientProperty("tableRowHeader", this);
        this.setSelectionModel(this.createSelectionModel());
        this.setCellRenderer(new DefaultRowHeaderRenderer());
        this._listener = new TableListener();
        table.addPropertyChangeListener("model", this._listener);
        table.addPropertyChangeListener("selectionModel", this._listener);
        this.setBackground(Color.white);
    }

    public JTable getTable() {
        return this._table;
    }

    public void setShowRowNumber(boolean show) {
        ListModel model = this.getModel();
        if (model instanceof BasicRowHeaderModel) {
            ((BasicRowHeaderModel)model).setShowRowNumber(show);
        }
    }

    public boolean isShowRowNumber() {
        ListModel model = this.getModel();
        if (model instanceof BasicRowHeaderModel) {
            return ((BasicRowHeaderModel)model).isShowRowNumber();
        }
        return false;
    }

    public void setRolloverHighlightingEnabled(boolean highlight) {
        if (this._highlight != highlight) {
            if (highlight) {
                if (this.rolloverListener == null) {
                    this.rolloverListener = new RolloverRowHeaderListener(this);
                }
                this.addMouseListener(this.rolloverListener);
                this.addMouseMotionListener(this.rolloverListener);
                this.setCellRenderer(new RolloverRowHeaderRenderer(this.getCellRenderer()));
            } else {
                this.removeMouseListener(this.rolloverListener);
                this.removeMouseMotionListener(this.rolloverListener);
                ListCellRenderer renderer = this.getCellRenderer();
                if (renderer instanceof RolloverRowHeaderRenderer) {
                    this.setCellRenderer(((RolloverRowHeaderRenderer)renderer).getBaseRenderer());
                }
            }
        }
    }

    public boolean isRolloverHighlightingEnabled() {
        return this._highlight;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        LookAndFeel.installProperty(this, "opaque", Boolean.TRUE);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getModel().getSize() == 0) {
            return new Dimension(0, 0);
        }
        return super.getPreferredScrollableViewportSize();
    }

    protected void modelChanged() {
        ListModel model = this.getModel();
        if (model instanceof BasicRowHeaderModel) {
            ((BasicRowHeaderModel)model).setTableModel(this._table.getModel());
        }
    }

    protected void selectionModelChanged() {
        ListSelectionModel selModel = this.getSelectionModel();
        if (selModel instanceof RowHeaderSelectionModel) {
            ((RowHeaderSelectionModel)selModel).setTable(this._table);
        }
    }

    @Override
    protected ListSelectionModel createSelectionModel() {
        if (this._table != null) {
            RowHeaderSelectionModel selModel = new RowHeaderSelectionModel();
            selModel.setTable(this._table);
            return selModel;
        }
        return super.createSelectionModel();
    }

    private class TableListener
    implements PropertyChangeListener {
        private TableListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("model".equals(name)) {
                RowHeader.this.modelChanged();
            } else if ("selectionModel".equals(name)) {
                RowHeader.this.selectionModelChanged();
            }
        }
    }
}

