/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.javatools.ui.table.table;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

abstract class RolloverListener
extends MouseInputAdapter {
    private JComponent _component;

    public RolloverListener(JComponent component) {
        this._component = component;
    }

    public abstract int[] getCell(Point var1);

    public JComponent getComponent() {
        return this._component;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.highlight(-1, -1);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.highlight(-1, -1);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int[] cell = this.getCell(e.getPoint());
        this.highlight(cell[0], cell[1]);
    }

    protected void highlight(int row, int column) {
        int oldRow;
        Object o = this._component.getClientProperty("ROLLOVER_COLUMN");
        int oldCol = o == null ? -1 : (Integer)o;
        o = this._component.getClientProperty("ROLLOVER_ROW");
        int n = oldRow = o == null ? -1 : (Integer)o;
        if (oldCol != column) {
            this._component.putClientProperty("ROLLOVER_COLUMN", column);
            this._component.repaint();
        }
        if (oldRow != row) {
            this._component.putClientProperty("ROLLOVER_ROW", row);
            this._component.repaint();
        }
    }
}

