/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.javatools.ui.table.table;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import oracle.dmt.javatools.ui.Colors;
import oracle.dmt.javatools.ui.table.table.ReorderableTable;
import oracle.dmt.javatools.ui.table.table.TableHelper;
import oracle.dmt.javatools.ui.table.table.TableToolbar;
import oracle.javatools.ui.Reorderable;
import oracle.javatools.ui.ReorderableBar;

public final class ReorderableTableWithTitleBar
extends JPanel {
    private static final Border _BORDER = BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.FLAT_EDITOR_BORDER);
    private JTable _table;
    private JComponent _tableContainer;
    private JPanel _centerPanel;
    private ReorderableBar _reorderBar;
    private ReorderableTable _reorderTable;
    private TableToolbar _tableBar;

    public ReorderableTableWithTitleBar() {
        this._init(null, null, false, false);
    }

    public ReorderableTableWithTitleBar(JTable table) {
        this._init(table, null, false, false);
    }

    public ReorderableTableWithTitleBar(JTable table, JComponent tablePanel) {
        this._init(table, tablePanel, false, false);
    }

    public ReorderableTableWithTitleBar(JTable table, boolean autoCreateReorderable, boolean autoCreateToolbar) {
        this._init(table, null, autoCreateReorderable, autoCreateToolbar);
    }

    public ReorderableTableWithTitleBar(JTable table, JComponent tablePanel, boolean autoCreateReorderable, boolean autoCreateToolbar) {
        this._init(table, tablePanel, autoCreateReorderable, autoCreateToolbar);
    }

    public void setTable(JTable table) {
        this._table = table;
        if (this.getTableContainer() == null) {
            this._addTableContainer(null);
        }
    }

    public JTable getTable() {
        return this._table;
    }

    public void setTableContainer(JComponent tablePanel) {
        if (this._tableContainer != tablePanel) {
            if (this._tableContainer != null) {
                this._centerPanel.remove(this._tableContainer);
            }
            this._addTableContainer(tablePanel);
        }
    }

    public JComponent getTableContainer() {
        return this._tableContainer;
    }

    public void setReorderableTable(ReorderableTable table) {
        if (this._reorderTable != table) {
            if (this._reorderTable != null) {
                this._reorderBar.setReorderable(null);
            }
            this._reorderTable = table;
            if (this._reorderTable == null) {
                this.remove((Component)this._reorderBar);
            } else {
                if (this._reorderBar == null) {
                    this._reorderBar = new ReorderableBar((Reorderable)this._reorderTable, true);
                } else {
                    this._reorderBar.setReorderable((Reorderable)this._reorderTable);
                }
                if (this._reorderBar.getParent() != this) {
                    this.add((Component)this._reorderBar, "East");
                }
            }
        }
    }

    public ReorderableTable getReorderableTable() {
        return this._reorderTable;
    }

    public ReorderableTable createDefaultReorderableTable() {
        return new ReorderableTable(this._table);
    }

    public void setTableToolbar(TableToolbar tableBar) {
        if (tableBar != this._tableBar) {
            if (this._tableBar != null) {
                this._centerPanel.remove(this._tableBar);
            }
            this._tableBar = tableBar;
            if (this._tableBar != null) {
                this._centerPanel.add((Component)this._tableBar, "North");
            }
        }
    }

    public TableToolbar getTableToolbar() {
        return this._tableBar;
    }

    public TableToolbar createDefaultTableToolbar() {
        return new TableToolbar(this._table);
    }

    private void _init(JTable table, JComponent tablePanel, boolean autoCreateReorderable, boolean autoCreateToolbar) {
        this.setLayout(new BorderLayout());
        this._centerPanel = new JPanel(new BorderLayout());
        this.add(this._centerPanel);
        this._table = table;
        if (tablePanel == null && table != null) {
            this._addTableContainer(null);
        } else {
            this.setTableContainer(tablePanel);
        }
        if (autoCreateReorderable) {
            this.setReorderableTable(this.createDefaultReorderableTable());
        }
        if (autoCreateToolbar) {
            this.setTableToolbar(this.createDefaultTableToolbar());
        }
    }

    private void _addTableContainer(JComponent tablePanel) {
        if (tablePanel == null) {
            tablePanel = this._table;
            JScrollPane scrollPane = TableHelper.getTableScrollPane(this._table);
            if (scrollPane != null) {
                tablePanel = scrollPane;
            }
        }
        this._tableContainer = tablePanel;
        this._centerPanel.add(this._tableContainer);
        Border b = this._tableContainer.getBorder();
        if (b == null || b instanceof UIResource) {
            this._tableContainer.setBorder(_BORDER);
        }
        this.revalidate();
        this.repaint();
    }
}

