/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.javatools.ui.table.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.javatools.ui.table.table.ReorderableTableModel;
import oracle.javatools.ui.Reorderable;

public class ReorderableTable
implements Reorderable {
    private static final int _UP = 1;
    private static final int _DOWN = 2;
    private static final int _TOP = 3;
    private static final int _BOTTOM = 4;
    private JTable _table;
    private Listener _listener;
    private EventListenerList _listenerList = new EventListenerList();

    public ReorderableTable(JTable table) {
        this._table = table;
        this._listener = new Listener();
        this._table.addPropertyChangeListener("rowSelectionAllowed", this._listener);
        this._table.addPropertyChangeListener("columnSelectionAllowed", this._listener);
    }

    public JTable getTable() {
        return this._table;
    }

    public boolean isSelectionTopMobile() {
        return this._isSelectionMobile(3);
    }

    public boolean isSelectionUpwardlyMobile() {
        return this._isSelectionMobile(1);
    }

    public boolean isSelectionDownwardlyMobile() {
        return this._isSelectionMobile(2);
    }

    public boolean isSelectionBottomMobile() {
        return this._isSelectionMobile(4);
    }

    public void moveSelectionTop() {
        this._moveSelection(3);
    }

    public void moveSelectionUp() {
        this._moveSelection(1);
    }

    public void moveSelectionDown() {
        this._moveSelection(2);
    }

    public void moveSelectionBottom() {
        this._moveSelection(4);
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this._listenerList.add(ListSelectionListener.class, listener);
        this._table.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeSelectionListener(ListSelectionListener listener) {
        this._listenerList.remove(ListSelectionListener.class, listener);
        this._table.getSelectionModel().removeListSelectionListener(listener);
    }

    protected void fireSelectionChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        ListSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e == null) {
                e = new ListSelectionEvent(this, 0, Math.min(0, this._table.getRowCount() - 1), false);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    private boolean _isSelectionMobile(int direction) {
        int rowCount = this._table.getRowCount();
        if (rowCount == 0 || !this._table.getRowSelectionAllowed()) {
            return false;
        }
        int[] rows = this._table.getSelectedRows();
        int rowsLength = rows.length;
        if (rows.length == 0) {
            return false;
        }
        switch (direction) {
            case 1: {
                return rows[0] != 0;
            }
            case 2: {
                return rows[rowsLength - 1] != rowCount - 1;
            }
            case 3: {
                if (rows[0] != 0) {
                    return true;
                }
                for (int i = 1; i < rowsLength; ++i) {
                    if (rows[i] == i) continue;
                    return true;
                }
                break;
            }
            case 4: {
                if (rows[rowsLength - 1] != rowCount - 1) {
                    return true;
                }
                for (int i = rowsLength - 2; i >= 0; --i) {
                    if (rows[i] == rows[i + 1] - 1) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private void _moveSelection(int direction) {
        TableModel model = this._table.getModel();
        ReorderableTableModel reorderModel = null;
        DefaultTableModel defModel = null;
        if (model instanceof ReorderableTableModel) {
            reorderModel = (ReorderableTableModel)((Object)model);
        } else if (model instanceof DefaultTableModel) {
            defModel = (DefaultTableModel)model;
        } else {
            return;
        }
        int[] rows = this._table.getSelectedRows();
        int rowsLength = rows.length;
        if (rows.length == 0) {
            return;
        }
        if (direction == 1) {
            for (int row : rows) {
                this._table.removeRowSelectionInterval(row, row);
                int modelIndex = this._table.convertRowIndexToModel(row);
                int endModelIndex = this._table.convertRowIndexToModel(row - 1);
                if (reorderModel != null) {
                    reorderModel.moveRow(modelIndex, modelIndex, endModelIndex);
                } else {
                    defModel.moveRow(modelIndex, modelIndex, endModelIndex);
                }
                int selIndex = this._table.convertRowIndexToView(endModelIndex);
                this._table.addRowSelectionInterval(selIndex, selIndex);
            }
            this._table.scrollRectToVisible(this._table.getCellRect(rows[0] - 1, 0, true));
        } else if (direction == 2) {
            for (int i = rowsLength - 1; i >= 0; --i) {
                int row = rows[i];
                this._table.removeRowSelectionInterval(row, row);
                int modelIndex = this._table.convertRowIndexToModel(row);
                int endModelIndex = this._table.convertRowIndexToModel(row + 1);
                if (reorderModel != null) {
                    reorderModel.moveRow(modelIndex, modelIndex, endModelIndex);
                } else {
                    defModel.moveRow(modelIndex, modelIndex, endModelIndex);
                }
                int selIndex = this._table.convertRowIndexToView(endModelIndex);
                this._table.addRowSelectionInterval(selIndex, selIndex);
            }
            this._table.scrollRectToVisible(this._table.getCellRect(rows[0] + 1, 0, true));
        } else if (direction == 3) {
            int start = 0;
            for (int row : rows) {
                int modelIndex = this._table.convertRowIndexToModel(row);
                int endModelIndex = this._table.convertRowIndexToModel(start);
                if (reorderModel != null) {
                    reorderModel.moveRow(modelIndex, modelIndex, endModelIndex);
                } else {
                    defModel.moveRow(modelIndex, modelIndex, endModelIndex);
                }
                ++start;
            }
            this._table.setRowSelectionInterval(0, rowsLength - 1);
            this._table.scrollRectToVisible(this._table.getCellRect(-1, 0, true));
        } else if (direction == 4) {
            int rowCount = this._table.getRowCount();
            int lastIndex = rowCount - 1;
            for (int i = rowsLength - 1; i >= 0; --i) {
                int modelIndex = this._table.convertRowIndexToModel(rows[i]);
                int endModelIndex = this._table.convertRowIndexToModel(lastIndex);
                if (reorderModel != null) {
                    reorderModel.moveRow(modelIndex, modelIndex, endModelIndex);
                } else {
                    defModel.moveRow(modelIndex, modelIndex, endModelIndex);
                }
                --lastIndex;
            }
            this._table.setRowSelectionInterval(rowCount - 1, rowCount - rowsLength);
            this._table.scrollRectToVisible(this._table.getCellRect(rowCount - 1, 0, true));
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            ReorderableTable.this.fireSelectionChanged();
        }
    }
}

