/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.javatools.ui.table.table;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ReflectiveTableCellRenderer
extends DefaultTableCellRenderer {
    private Method textMethod;
    private Object[] textParameterValues;
    private Class[] textParameterClasses;
    private String textMethodName;
    private Method iconMethod;
    private Object[] iconParameterValues;
    private Class[] iconParameterClasses;
    private String iconMethodName;

    public ReflectiveTableCellRenderer(String textMethodName) {
        this.textMethodName = textMethodName;
    }

    public ReflectiveTableCellRenderer(String textMethodName, Class[] textParameterClasses, Object[] textParameterValues) {
        this.textMethodName = textMethodName;
        this.textParameterClasses = textParameterClasses;
        this.textParameterValues = textParameterValues;
    }

    public ReflectiveTableCellRenderer(String textMethodName, String iconMethodName) {
        this.textMethodName = textMethodName;
        this.iconMethodName = iconMethodName;
    }

    public ReflectiveTableCellRenderer(String textMethodName, Class[] textParameterClasses, Object[] textParameterValues, String iconMethodName, Class[] iconParameterClasses, Object[] iconParameterValues) {
        this.textMethodName = textMethodName;
        this.textParameterClasses = textParameterClasses;
        this.textParameterValues = textParameterValues;
        this.iconMethodName = iconMethodName;
        this.iconParameterClasses = iconParameterClasses;
        this.iconParameterValues = iconParameterValues;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, cellHasFocus, row, column);
        try {
            Object ret;
            if (this.textMethod == null && this.textMethodName != null && value != null) {
                this.textMethod = value.getClass().getMethod(this.textMethodName, this.textParameterClasses);
            }
            if (this.iconMethod == null && this.iconMethodName != null && value != null) {
                this.iconMethod = value.getClass().getMethod(this.iconMethodName, this.iconParameterClasses);
            }
            if (this.textMethod != null && (ret = this.textMethod.invoke(value, this.textParameterValues)) != null) {
                label.setText(ret.toString());
            }
            if (this.iconMethod != null && (ret = this.iconMethod.invoke(value, this.iconParameterValues)) != null) {
                label.setIcon((Icon)ret);
            }
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.SEVERE, "Cannot render table item: " + value, e);
        }
        return label;
    }
}

