/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.javatools.ui.table.table;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JTable;
import oracle.dmt.javatools.ui.table.table.CheckRowHeaderRenderer;
import oracle.dmt.javatools.ui.table.table.RowHeader;
import oracle.dmt.javatools.ui.table.table.SimpleTableModel;

public class CheckRowHeader
extends RowHeader {
    protected Collection checkedItems;
    private CheckListener checkListener = new CheckListener();

    public CheckRowHeader(JTable table, Collection checkedItems) {
        super(table);
        this.checkedItems = checkedItems;
        this.setCellRenderer(new CheckRowHeaderRenderer(table, checkedItems));
        this.addMouseListener(this.checkListener);
        table.addKeyListener(this.checkListener);
    }

    protected SimpleTableModel getTableModel() {
        assert (this.getTable().getModel() instanceof SimpleTableModel) : "CheckRowHeader is currently only compatible with SimpleTableModels";
        return (SimpleTableModel)this.getTable().getModel();
    }

    private class CheckListener
    extends MouseAdapter
    implements KeyListener {
        private CheckListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int i = CheckRowHeader.this.locationToIndex(e.getPoint());
            Rectangle cellBounds = CheckRowHeader.this.getCellBounds(i, i);
            if (cellBounds.contains(e.getPoint())) {
                int viewIndex = CheckRowHeader.this.getTable().convertRowIndexToModel(i);
                Object rowObject = CheckRowHeader.this.getTableModel().getRow(viewIndex);
                if (CheckRowHeader.this.checkedItems.contains(rowObject)) {
                    CheckRowHeader.this.checkedItems.remove(rowObject);
                } else {
                    CheckRowHeader.this.checkedItems.add(rowObject);
                }
                CheckRowHeader.this.repaint(cellBounds);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!(e.getKeyCode() != 32 || e.isControlDown() || e.isAltDown() || e.isShiftDown())) {
                for (int i : CheckRowHeader.this.getTable().getSelectedRows()) {
                    int viewIndex = CheckRowHeader.this.getTable().convertRowIndexToModel(i);
                    Object rowObject = CheckRowHeader.this.getTableModel().getRow(viewIndex);
                    if (CheckRowHeader.this.checkedItems.contains(rowObject)) {
                        CheckRowHeader.this.checkedItems.remove(rowObject);
                    } else {
                        CheckRowHeader.this.checkedItems.add(rowObject);
                    }
                    CheckRowHeader.this.repaint(CheckRowHeader.this.getCellBounds(i, i));
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

