/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.javatools.ui.table.table;

import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class BasicRowHeaderModel
extends AbstractListModel {
    private boolean _showNumber;
    private ListModel _baseListModel;
    private TableModel _tableModel;
    private Listener _listener;

    public BasicRowHeaderModel(TableModel tableModel) {
        this._init(tableModel, false, null);
    }

    public BasicRowHeaderModel(TableModel tableModel, boolean showNumber) {
        this._init(tableModel, showNumber, null);
    }

    public BasicRowHeaderModel(TableModel tableModel, ListModel baseModel) {
        this._init(tableModel, false, baseModel);
    }

    public void setShowRowNumber(boolean show) {
        if (show != this.isShowRowNumber()) {
            this._showNumber = show;
            this.fireContentsChanged(this, 0, Math.max(this._tableModel.getRowCount() - 1, 0));
        }
    }

    public boolean isShowRowNumber() {
        return this._showNumber;
    }

    public void setTableModel(TableModel tableModel) {
        if (tableModel != this._tableModel) {
            if (tableModel == null) {
                throw new IllegalArgumentException("TableModel cannot be null");
            }
            if (this._tableModel != null) {
                this._tableModel.removeTableModelListener(this._listener);
                this.fireIntervalRemoved(this, 0, Math.max(this._tableModel.getRowCount() - 1, 0));
            }
            this._tableModel = tableModel;
            this.fireIntervalAdded(this, 0, Math.max(this._tableModel.getRowCount() - 1, 0));
            this._tableModel.addTableModelListener(this._listener);
        }
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    public void setBaseListModel(ListModel baseModel) {
        if (baseModel != this._baseListModel) {
            if (this._baseListModel != null) {
                this._baseListModel.removeListDataListener(this._listener);
                this.fireIntervalRemoved(this, 0, Math.max(this._tableModel.getRowCount() - 1, 0));
            }
            this._baseListModel = baseModel;
            if (this._baseListModel != null) {
                this.fireIntervalAdded(this, 0, Math.max(this._tableModel.getRowCount() - 1, 0));
                this._baseListModel.addListDataListener(this._listener);
            }
        }
    }

    public ListModel getBaseListMode() {
        return this._baseListModel;
    }

    @Override
    public int getSize() {
        return this._tableModel.getRowCount();
    }

    @Override
    public Object getElementAt(int index) {
        if (this._baseListModel != null && index >= 0 && index < this._baseListModel.getSize()) {
            return this._baseListModel.getElementAt(index);
        }
        if (this.isShowRowNumber()) {
            return index + 1;
        }
        return "";
    }

    private void _init(TableModel tableModel, boolean showNum, ListModel delegator) {
        this._listener = new Listener();
        this.setTableModel(tableModel);
        this.setShowRowNumber(showNum);
        this.setBaseListModel(delegator);
    }

    private class Listener
    implements TableModelListener,
    ListDataListener {
        private Listener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            switch (e.getType()) {
                case 1: {
                    BasicRowHeaderModel.this.fireIntervalAdded(BasicRowHeaderModel.this, e.getFirstRow(), e.getLastRow());
                    break;
                }
                case -1: {
                    BasicRowHeaderModel.this.fireIntervalRemoved(BasicRowHeaderModel.this, e.getFirstRow(), e.getLastRow());
                    break;
                }
                case 0: {
                    BasicRowHeaderModel.this.fireContentsChanged(BasicRowHeaderModel.this, e.getFirstRow(), e.getLastRow());
                }
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            BasicRowHeaderModel.this.fireIntervalAdded(BasicRowHeaderModel.this, e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            BasicRowHeaderModel.this.fireIntervalRemoved(BasicRowHeaderModel.this, e.getIndex0(), e.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            BasicRowHeaderModel.this.fireContentsChanged(BasicRowHeaderModel.this, e.getIndex0(), e.getIndex1());
        }
    }
}

