/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.servlet;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMView;
import ilog.views.sdm.renderer.IlvRendererUtil;
import ilog.views.servlet.IlvImageMapAreaGenerator;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class IlvSDMImageMapAreaGenerator
extends IlvImageMapAreaGenerator {
    private String a = "select";

    public int getShape(IlvManagerView ilvManagerView, IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        if (ilvGraphic instanceof IlvLinkImage) {
            return 2;
        }
        return super.getShape(ilvManagerView, ilvGraphic, ilvTransformer);
    }

    public String generateCOORDS(IlvManagerView ilvManagerView, IlvGraphic ilvGraphic, IlvRect ilvRect, IlvTransformer ilvTransformer) {
        if (ilvGraphic instanceof IlvLinkImage) {
            IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
            IlvPoint[] ilvPointArray = ilvLinkImage.getLinkPoints(ilvTransformer);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
            for (int i = 1; i < ilvPointArray.length; ++i) {
                generalPath.lineTo(ilvPointArray[i].x, ilvPointArray[i].y);
            }
            BasicStroke basicStroke = new BasicStroke(ilvLinkImage.getLineWidth(ilvTransformer) * 2.0f, 0, 2);
            Shape shape = basicStroke.createStrokedShape(generalPath);
            Area area = new Area(shape);
            area.intersect(new Area(new Rectangle2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height)));
            PathIterator pathIterator = area.getPathIterator(null);
            float[] fArray = new float[6];
            float f = 0.0f;
            float f2 = 0.0f;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            while (!pathIterator.isDone()) {
                float f3;
                float f4;
                int n = pathIterator.currentSegment(fArray);
                switch (n) {
                    case 0: {
                        f4 = fArray[0];
                        f3 = fArray[1];
                        if (bl) break;
                        f = f4;
                        f2 = f3;
                        break;
                    }
                    case 1: {
                        f4 = fArray[0];
                        f3 = fArray[1];
                        break;
                    }
                    case 2: {
                        f4 = fArray[2];
                        f3 = fArray[3];
                        break;
                    }
                    case 3: {
                        f4 = fArray[4];
                        f3 = fArray[5];
                        break;
                    }
                    case 4: {
                        f4 = f;
                        f3 = f2;
                        break;
                    }
                    default: {
                        throw new RuntimeException("cannot happen");
                    }
                }
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((int)f4);
                stringBuffer.append(",");
                stringBuffer.append((int)f3);
                bl = true;
                pathIterator.next();
            }
            return stringBuffer.toString();
        }
        return super.generateCOORDS(ilvManagerView, ilvGraphic, ilvRect, ilvTransformer);
    }

    public String generateHREF(IlvManagerView ilvManagerView, IlvGraphic ilvGraphic) {
        IlvSDMEngine ilvSDMEngine = ((IlvSDMView)ilvManagerView).getSDMEngine();
        Object object = ilvSDMEngine.getObject(ilvGraphic);
        if (object == null) {
            return null;
        }
        String string = IlvRendererUtil.getGraphicPropertyAsString(ilvSDMEngine, object, "imageMapHRef", null, null);
        if (string != null) {
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
        String string2 = null;
        string2 = ilvSDMEngine.getID(object);
        String string3 = IlvRendererUtil.getGraphicPropertyAsString(ilvSDMEngine, object, "imageMapFunction", null, null);
        if (string3 == null) {
            string3 = this.a;
        }
        return "javascript:" + string3 + "('" + string2 + "')";
    }

    public void setImageMapFunction(String string) {
        this.a = string;
    }

    public String getImageMapFunction() {
        return this.a;
    }

    public String generateALT(IlvManagerView ilvManagerView, IlvGraphic ilvGraphic) {
        IlvSDMEngine ilvSDMEngine = ((IlvSDMView)ilvManagerView).getSDMEngine();
        Object object = ilvSDMEngine.getObject(ilvGraphic);
        if (object == null) {
            return null;
        }
        String string = null;
        if (string == null) {
            string = IlvRendererUtil.getGraphicPropertyAsString(ilvSDMEngine, object, "imageMapAlt", null, null);
        }
        if (string == null) {
            string = IlvRendererUtil.getGraphicPropertyAsString(ilvSDMEngine, object, "name", null, null);
        }
        if (string == null) {
            string = IlvRendererUtil.getGraphicPropertyAsString(ilvSDMEngine, object, "toolTipText", null, null);
        }
        if (string == null) {
            string = ilvSDMEngine.getID(object);
        }
        return string;
    }
}

