/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.tree;

import ilog.views.IlvGraphic;
import ilog.views.IlvNamedProperty;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGrapherAdapter;
import ilog.views.graphlayout.internalutil.AlignmentOptions;
import ilog.views.graphlayout.tree.IlvTreeLayout;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvTreeLayoutNodeProperty
extends IlvGraphLayoutNodeProperty {
    static final long serialVersionUID = 4461764449158199120L;
    private int a;
    private int b;
    private float c;
    private float d;
    private float e;
    private float f;
    private int g;
    private boolean h;
    private IlvGraphic i;
    private IlvGraphic j;
    private IlvGraphic k;

    public IlvTreeLayoutNodeProperty(String string, IlvTreeLayout ilvTreeLayout, IlvGraphic ilvGraphic, boolean bl) {
        super(string, ilvTreeLayout, ilvGraphic, bl);
        try {
            this.a = ilvTreeLayout.getRootPreference(ilvGraphic);
        }
        catch (Exception exception) {
            this.a = -1;
        }
        try {
            this.b = ilvTreeLayout.getAlignment(ilvGraphic);
        }
        catch (Exception exception) {
            this.b = 0;
        }
        try {
            this.c = ilvTreeLayout.getEastSubtreeBlockMargin(ilvGraphic);
        }
        catch (Exception exception) {
            this.c = -1.0f;
        }
        try {
            this.d = ilvTreeLayout.getWestSubtreeBlockMargin(ilvGraphic);
        }
        catch (Exception exception) {
            this.d = -1.0f;
        }
        try {
            this.e = ilvTreeLayout.getNorthSubtreeBlockMargin(ilvGraphic);
        }
        catch (Exception exception) {
            this.e = -1.0f;
        }
        try {
            this.f = ilvTreeLayout.getSouthSubtreeBlockMargin(ilvGraphic);
        }
        catch (Exception exception) {
            this.f = -1.0f;
        }
        try {
            this.g = ilvTreeLayout.getChildAlignment(ilvGraphic);
        }
        catch (Exception exception) {
            this.g = -1;
        }
        try {
            this.h = ilvTreeLayout.a6.contains(ilvGraphic);
        }
        catch (Exception exception) {
            this.h = false;
        }
        Object object = ilvTreeLayout.getEastNeighbor(ilvGraphic);
        this.i = object instanceof IlvGraphic ? (IlvGraphic)object : null;
        object = ilvTreeLayout.getWestNeighbor(ilvGraphic);
        this.j = object instanceof IlvGraphic ? (IlvGraphic)object : null;
        object = ilvTreeLayout.getAssociateParent(ilvGraphic);
        this.k = object instanceof IlvGraphic ? (IlvGraphic)object : null;
    }

    public IlvTreeLayoutNodeProperty(IlvTreeLayoutNodeProperty ilvTreeLayoutNodeProperty) {
        super(ilvTreeLayoutNodeProperty);
        this.a = ilvTreeLayoutNodeProperty.a;
        this.b = ilvTreeLayoutNodeProperty.b;
        this.c = ilvTreeLayoutNodeProperty.c;
        this.d = ilvTreeLayoutNodeProperty.d;
        this.e = ilvTreeLayoutNodeProperty.e;
        this.f = ilvTreeLayoutNodeProperty.f;
        this.g = ilvTreeLayoutNodeProperty.g;
        this.h = ilvTreeLayoutNodeProperty.h;
        this.i = ilvTreeLayoutNodeProperty.i;
        this.j = ilvTreeLayoutNodeProperty.j;
        this.k = ilvTreeLayoutNodeProperty.k;
    }

    public IlvTreeLayoutNodeProperty(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
        try {
            this.a = ilvInputStream.readInt("rootPreference");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.a = -1;
        }
        try {
            this.b = AlignmentOptions.valueOf(ilvInputStream.readString("alignment"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.b = 0;
        }
        try {
            this.c = ilvInputStream.readFloat("eastSubtreeBlockMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.c = -1.0f;
        }
        try {
            this.d = ilvInputStream.readFloat("westSubtreeBlockMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.d = -1.0f;
        }
        try {
            this.e = ilvInputStream.readFloat("northSubtreeBlockMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.e = -1.0f;
        }
        try {
            this.f = ilvInputStream.readFloat("southSubtreeBlockMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.f = -1.0f;
        }
        try {
            this.g = AlignmentOptions.valueOf(ilvInputStream.readString("childAlignment"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.g = -1;
        }
        try {
            this.h = ilvInputStream.readBoolean("isRoot");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.h = false;
        }
        try {
            this.i = ilvInputStream.readObject("eastNeighbor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.i = null;
        }
        try {
            this.j = ilvInputStream.readObject("westNeighbor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.j = null;
        }
        try {
            this.k = ilvInputStream.readObject("assocParent");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.k = null;
        }
    }

    public IlvNamedProperty copy() {
        return new IlvTreeLayoutNodeProperty(this);
    }

    public boolean isPersistent() {
        if (super.isPersistent()) {
            return true;
        }
        if (this.a != -1) {
            return true;
        }
        if (this.b != 0) {
            return true;
        }
        if (this.c != -1.0f) {
            return true;
        }
        if (this.d != -1.0f) {
            return true;
        }
        if (this.e != -1.0f) {
            return true;
        }
        if (this.f != -1.0f) {
            return true;
        }
        if (this.g != -1) {
            return true;
        }
        if (this.h) {
            return true;
        }
        if (this.i != null) {
            return true;
        }
        if (this.j != null) {
            return true;
        }
        return this.k != null;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        if (this.a != -1 || !this.omitDefaults()) {
            ilvOutputStream.write("rootPreference", this.a);
        }
        if (this.b != 0 || !this.omitDefaults()) {
            ilvOutputStream.write("alignment", AlignmentOptions.toString(this.b));
        }
        if (this.c != -1.0f || !this.omitDefaults()) {
            ilvOutputStream.write("eastSubtreeBlockMargin", this.c);
        }
        if (this.d != -1.0f || !this.omitDefaults()) {
            ilvOutputStream.write("westSubtreeBlockMargin", this.d);
        }
        if (this.e != -1.0f || !this.omitDefaults()) {
            ilvOutputStream.write("northSubtreeBlockMargin", this.e);
        }
        if (this.f != -1.0f || !this.omitDefaults()) {
            ilvOutputStream.write("southSubtreeBlockMargin", this.f);
        }
        if (this.g != -1 || !this.omitDefaults()) {
            ilvOutputStream.write("childAlignment", AlignmentOptions.toString(this.g));
        }
        if (this.h || !this.omitDefaults()) {
            ilvOutputStream.write("isRoot", this.h);
        }
        if (this.i != null && this.isWritten(this.i)) {
            ilvOutputStream.write("eastNeighbor", this.i);
        }
        if (this.j != null && this.isWritten(this.j)) {
            ilvOutputStream.write("westNeighbor", this.j);
        }
        if (this.k != null) {
            ilvOutputStream.write("assocParent", this.k);
        }
    }

    public void transfer(IlvGraphLayout ilvGraphLayout, IlvGraphic ilvGraphic) {
        if (ilvGraphLayout == null) {
            return;
        }
        super.transfer(ilvGraphLayout, ilvGraphic);
        IlvTreeLayout ilvTreeLayout = (IlvTreeLayout)ilvGraphLayout;
        try {
            if (this.h) {
                ilvTreeLayout.setRoot(ilvGraphic);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvTreeLayout.setRootPreference(ilvGraphic, this.a);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvTreeLayout.setAlignment(ilvGraphic, this.b);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvTreeLayout.setEastSubtreeBlockMargin(ilvGraphic, this.c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvTreeLayout.setWestSubtreeBlockMargin(ilvGraphic, this.d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvTreeLayout.setNorthSubtreeBlockMargin(ilvGraphic, this.e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvTreeLayout.setSouthSubtreeBlockMargin(ilvGraphic, this.f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvTreeLayout.setChildAlignment(ilvGraphic, this.g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.i != null) {
            ilvTreeLayout.setEastWestNeighboring(this.i, ilvGraphic);
        }
        if (this.j != null) {
            ilvTreeLayout.setWestEastNeighboring(this.j, ilvGraphic);
        }
        if (this.k != null) {
            ilvTreeLayout.addAssociate(this.k, ilvGraphic);
        }
    }

    public void dispose(IlvGrapherAdapter ilvGrapherAdapter) {
        super.dispose(ilvGrapherAdapter);
    }
}

