/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.hierarchical.ConstraintManager;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalConstraint;
import ilog.views.graphlayout.hierarchical.IlvNodeGroup;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvLevelRangeConstraint
extends IlvHierarchicalConstraint {
    static final long serialVersionUID = 7247930267832682855L;
    private Object a;
    private int b;
    private int c;

    public IlvLevelRangeConstraint(Object object, int n, int n2) {
        super(3.062541E38f);
        this.a = object;
        this.setLevelRange(n, n2);
    }

    public IlvLevelRangeConstraint(IlvLevelRangeConstraint ilvLevelRangeConstraint) {
        super(ilvLevelRangeConstraint);
        this.a = ilvLevelRangeConstraint.a;
        this.b = ilvLevelRangeConstraint.b;
        this.c = ilvLevelRangeConstraint.c;
    }

    public IlvLevelRangeConstraint(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
        try {
            this.a = ilvInputStream.readPersistentObject("subject");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.a = null;
        }
        try {
            this.b = ilvInputStream.readInt("minLevel");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.b = -1;
        }
        try {
            this.c = ilvInputStream.readInt("maxLevel");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.c = -1;
        }
    }

    public IlvHierarchicalConstraint copy() {
        return new IlvLevelRangeConstraint(this);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        Object object = this.getSubject();
        if (object instanceof IlvNodeGroup) {
            ilvOutputStream.write("subject", (IlvPersistentObject)((IlvNodeGroup)object));
        }
        ilvOutputStream.write("minLevel", this.b);
        ilvOutputStream.write("maxLevel", this.c);
    }

    public final Object getSubject() {
        return this.a;
    }

    public final int getMinLevel() {
        return this.b;
    }

    public final void setMinLevel(int n) {
        if (n < 0) {
            this.b = -1;
        } else {
            this.b = n;
            if (this.c >= 0) {
                this.c = Math.max(this.c, n);
            }
        }
    }

    public final int getMaxLevel() {
        return this.c;
    }

    public final void setMaxLevel(int n) {
        if (n < 0) {
            this.c = -1;
        } else {
            this.c = n;
            if (this.b >= 0) {
                this.b = Math.min(this.b, n);
            }
        }
    }

    public final void setLevelRange(int n, int n2) {
        if (n2 < 0) {
            this.b = n;
            this.c = -1;
        } else if (n <= n2) {
            this.b = n;
            this.c = n2;
        } else {
            this.b = n2;
            this.c = n;
        }
    }

    final Object a() {
        return this.a;
    }

    final void a(Object object) {
        this.a = object;
    }

    final boolean a(IlvGraphModel ilvGraphModel) {
        return this.b(ilvGraphModel, this.getSubject());
    }

    final void a(HGraph hGraph) {
        this.a(true);
        this.b(hGraph, this.getSubject());
    }

    final void a(ConstraintManager constraintManager) {
        Object object = this.getSubject();
        if (object instanceof IlvNodeGroup) {
            constraintManager.a((IlvNodeGroup)object);
        }
    }
}

