/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.diagrammer.project;

import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.IlvDiagrammerException;
import ilog.views.diagrammer.datasource.IlvDiagrammerDataSource;
import ilog.views.diagrammer.internal.DiagrammerUtilities;
import ilog.views.diagrammer.project.IlvNotAProjectException;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.xml.XMLUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class IlvDiagrammerProject {
    private URL a;
    private ArrayList b = new ArrayList();
    private ArrayList c = new ArrayList();
    private IlvDiagrammerDataSource d;
    private ClassLoader e;
    private static final String f = "diagrammer";
    private static final String g = "style";
    private static final String h = "datasource";
    private static final String i = "resource:";
    public static String suffix = ".idpr";
    public static final String shortDescription = "ShortDescription";
    public static final String longDescription = "LongDescription";
    private File j;

    public IlvDiagrammerProject() {
    }

    public IlvDiagrammerProject(URL uRL) throws IlvDiagrammerException {
        this.read(uRL);
    }

    public void setStyleSheet(URL uRL) {
        this.b.clear();
        this.c.clear();
        this.addStyleSheet(uRL);
    }

    public URL getStyleSheet() {
        if (this.b.size() > 0) {
            return (URL)this.b.get(0);
        }
        return null;
    }

    public void addStyleSheet(URL uRL) {
        this.a(uRL, null);
    }

    private void a(URL uRL, String string) {
        if (!this.b.contains(uRL)) {
            this.b.add(uRL);
            this.c.add(string);
        }
    }

    public void removeStyleSheet(URL uRL) {
        int n = this.b.indexOf(uRL);
        if (n >= 0) {
            this.b.remove(n);
            this.c.remove(n);
        }
    }

    public URL[] getStyleSheets() {
        return this.b.toArray(new URL[0]);
    }

    public IlvDiagrammerDataSource getDataSource() {
        return this.d;
    }

    public void setDataSource(IlvDiagrammerDataSource ilvDiagrammerDataSource) {
        this.d = ilvDiagrammerDataSource;
    }

    public Object getProperty(String string, Locale locale) {
        ResourceBundle resourceBundle = this.a(locale);
        if (resourceBundle != null) {
            try {
                return resourceBundle.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public Object getProperty(String string) {
        return this.getProperty(string, Locale.getDefault());
    }

    public Object getProperty(File file, String string) {
        this.j = file;
        return this.getProperty(string, Locale.getDefault());
    }

    private ResourceBundle a(Locale locale) {
        if (this.a != null) {
            int n;
            String string;
            if (this.e == null) {
                try {
                    string = this.a.toExternalForm();
                    n = string.lastIndexOf(47);
                    if (n >= 0) {
                        string = string.substring(0, n + 1);
                    }
                    URL uRL = new URL(string);
                    this.e = new URLClassLoader(new URL[]{uRL});
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if ((string = this.a.getFile()) != null) {
                n = (string = new File(string).getName()).lastIndexOf(46);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                return IlvDiagrammerProject.a(this.j, string, locale);
            }
        }
        return null;
    }

    private static ResourceBundle a(File file, String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            String string2 = file.toString().replace(File.separatorChar, '.') + '.' + string;
            resourceBundle = IlvResourceUtil.getBundle((String)string2, (Locale)locale);
        }
        catch (Exception exception) {
            try {
                URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURL()});
                resourceBundle = IlvResourceUtil.getBundle((String)string, (Locale)locale, (ClassLoader)uRLClassLoader);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return resourceBundle;
    }

    public URL getProjectURL() {
        return this.a;
    }

    private void a(URL uRL) {
        this.a = uRL;
        this.e = null;
    }

    public void read(URL uRL) throws IlvDiagrammerException {
        this.a(uRL);
        try {
            Object object;
            Object object2;
            InputSource inputSource = new InputSource(uRL.toExternalForm());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            Element element = document.getDocumentElement();
            if (!element.getTagName().equals(f)) {
                throw new IlvNotAProjectException("Not a Diagrammer project file: ", uRL);
            }
            String string = element.getAttribute(g);
            if (string.length() > 0) {
                while (this.getStyleSheets().length > 0) {
                    this.removeStyleSheet(this.getStyleSheets()[0]);
                }
                object2 = new StringTokenizer(string, ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    URL uRL2;
                    object = ((StringTokenizer)object2).nextToken();
                    Object object3 = null;
                    if (((String)object).startsWith(i)) {
                        object3 = object;
                        object = ((String)object).substring(i.length());
                        uRL2 = IlvDiagrammer.class.getResource((String)object);
                        if (uRL2 == null) {
                            throw new IlvDiagrammerException("Style sheet not found: " + (String)object);
                        }
                    } else {
                        uRL2 = new URL(this.a, (String)object);
                    }
                    this.a(uRL2, (String)object3);
                }
            }
            if ((object2 = element.getElementsByTagName(h)).getLength() > 0) {
                if (object2.getLength() > 1) {
                    throw new IlvDiagrammerException("Each project can contain at most one data source");
                }
                object = (Element)object2.item(0);
                this.d = IlvDiagrammerDataSource.deserialize((Element)object, uRL);
            } else {
                this.d = null;
            }
        }
        catch (IlvDiagrammerException ilvDiagrammerException) {
            throw ilvDiagrammerException;
        }
        catch (Exception exception) {
            throw new IlvDiagrammerException("Exception while reading project", exception);
        }
    }

    public void write(URL uRL) throws IlvDiagrammerException {
        this.a(uRL);
        try {
            Object object;
            OutputStream outputStream = uRL.getProtocol().equals("file") ? new FileOutputStream(IlvURLUtil.convertFileURLToFilename((URL)uRL)) : uRL.openConnection().getOutputStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(f);
            document.appendChild(element);
            URL[] uRLArray = this.getStyleSheets();
            if (uRLArray.length > 0) {
                object = null;
                for (int i = 0; i < uRLArray.length; ++i) {
                    URL uRL2 = uRLArray[i];
                    String string = (String)this.c.get(i);
                    if (string == null) {
                        if (uRL2.getProtocol().equals("jar")) {
                            string = uRL2.toExternalForm();
                            string = i + string.substring(string.indexOf(33) + 1);
                        } else {
                            string = DiagrammerUtilities.relativeURL(this.a, uRL2);
                        }
                    }
                    object = i == 0 ? string : (String)object + "," + string;
                }
                element.setAttribute(g, (String)object);
            }
            if (this.getDataSource() != null) {
                object = this.getDataSource();
                Element element2 = document.createElement(h);
                element.appendChild(element2);
                ((IlvDiagrammerDataSource)object).serialize(element2, uRL);
            }
            XMLUtil.WriteDocument((Document)document, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (IlvDiagrammerException ilvDiagrammerException) {
            throw ilvDiagrammerException;
        }
        catch (Exception exception) {
            throw new IlvDiagrammerException("Exception while serializing data souce", exception);
        }
    }
}

