/*
 * Decompiled with CFR 0.152.
 */
package oracle.jldif.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import oracle.jldif.util.LDIFReader;
import oracle.jldif.util.LDIFRecord;

public class LDIFWriter {
    private static final String lineSeparator = System.getProperty("line.separator");
    private int maxLineLen = 76;
    private boolean wrap = true;
    private static final String ENCODING = "UTF8";
    private static String DEFAULT_ENCODING = null;
    private BufferedWriter outBuf = null;

    public LDIFWriter() throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, ENCODING));
    }

    public LDIFWriter(String file) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
    }

    public LDIFWriter(File fileObj) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileObj), ENCODING));
    }

    public LDIFWriter(OutputStream out) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter(out, ENCODING));
    }

    public LDIFWriter(OutputStream out, String enc) throws IOException {
        if (enc == null) {
            enc = DEFAULT_ENCODING;
        }
        this.outBuf = new BufferedWriter(new OutputStreamWriter(out, enc));
    }

    public LDIFWriter(String file, boolean wrap) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
        this.wrap = wrap;
    }

    public LDIFWriter(File fileObj, boolean wrap) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileObj), ENCODING));
        this.wrap = wrap;
    }

    public LDIFWriter(OutputStream out, boolean wrap) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter(out, ENCODING));
        this.wrap = wrap;
    }

    private void ensureOpen() throws IOException {
        if (this.outBuf == null) {
            throw new IOException("Stream closed");
        }
    }

    public void newLine() throws IOException {
        this.ensureOpen();
        this.outBuf.write(lineSeparator);
    }

    private void writeAttribute(String attrStr) throws IOException {
        int len;
        int startIndex = 0;
        int endIndex = 0;
        if (attrStr == null || (len = attrStr.length()) == 0) {
            return;
        }
        this.ensureOpen();
        if (!this.wrap) {
            this.outBuf.write(attrStr);
        } else {
            endIndex = Math.min(len, this.maxLineLen);
            while (true) {
                this.outBuf.write(attrStr.substring(startIndex, endIndex));
                startIndex = endIndex;
                endIndex = Math.min(len - endIndex, this.maxLineLen);
                if (endIndex == 0) break;
                this.newLine();
                this.outBuf.write(32);
                endIndex += startIndex;
            }
        }
    }

    void writeAttribute(String type, String value) throws IOException {
        if (null == type || null == value) {
            return;
        }
        this.writeAttribute(type + ": " + value);
        this.newLine();
        this.outBuf.flush();
    }

    public void setMaxLineLen(int maxLineLen) {
        this.maxLineLen = maxLineLen;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public void writeEntry(LDIFRecord ldifRecord) throws IOException {
        this.ensureOpen();
        this.outBuf.write(ldifRecord.getRecordAsString(false, this.wrap));
        this.outBuf.flush();
    }

    public void writeEntryAsComment(LDIFRecord ldifRecord) throws IOException {
        this.ensureOpen();
        this.outBuf.write(ldifRecord.getRecordAsString(true, this.wrap));
        this.outBuf.flush();
    }

    public void writeEntry(Vector vEntry) throws IOException {
        int sz;
        if (vEntry == null || (sz = vEntry.size()) == 0) {
            return;
        }
        for (int ix = 0; ix < sz; ++ix) {
            this.writeAttribute((String)vEntry.elementAt(ix));
            this.newLine();
        }
        this.newLine();
    }

    public void writeComment(String comment) throws IOException {
        this.ensureOpen();
        this.outBuf.write("# " + comment);
        this.outBuf.newLine();
    }

    public synchronized void close() throws IOException {
        if (this.outBuf != null) {
            this.outBuf.flush();
            this.outBuf.close();
        }
        this.outBuf = null;
    }

    private static void test1(String inFile, String outFile) {
        LDIFReader ldifReader = null;
        LDIFWriter ldifWriter = null;
        String[] bAttrs = new String[]{"jpegphoto"};
        try {
            ldifReader = new LDIFReader(inFile);
            ldifReader.setBinaryAttributes(bAttrs);
            ldifWriter = new LDIFWriter(outFile);
        }
        catch (Exception e) {
            System.err.println("Error while opening LDIF file ");
            System.err.println(e.toString());
            System.exit(1);
        }
        try {
            LDIFRecord record = null;
            while ((record = ldifReader.nextRecord()) != null) {
                ldifWriter.writeEntry(record);
                ldifWriter.newLine();
            }
            ldifReader.close();
            ldifWriter.close();
        }
        catch (IOException ex) {
            System.out.println("Error while reading/writing the LDIF File ");
            System.exit(1);
        }
    }

    private static void test2(String inFile, String outFile) {
        LDIFReader ldifReader = null;
        LDIFWriter ldifWriter = null;
        try {
            ldifReader = new LDIFReader(inFile);
            ldifWriter = new LDIFWriter(outFile);
        }
        catch (Exception e) {
            System.err.println("Error while opening the LDIF file ");
            System.err.println(e);
            System.exit(1);
        }
        try {
            Vector<String> vect = ldifReader.nextEntry();
            while (vect != null) {
                ldifWriter.writeEntry(vect);
                vect = ldifReader.nextEntry();
            }
            ldifWriter.close();
        }
        catch (IOException ex) {
            System.out.println("Error while reading/writing the LDIF File ");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java LDIFWriter <FILE1> <FILE2> ....");
            System.exit(1);
        }
        LDIFWriter.test1(args[0], args[1] + ".1");
        LDIFWriter.test2(args[0], args[1] + ".2");
        System.exit(0);
    }

    static {
        DEFAULT_ENCODING = System.getProperty("file.encoding");
    }
}

