/*
 * Decompiled with CFR 0.152.
 */
package oracle.jldif.util;

import java.util.Vector;
import oracle.jldif.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDIFSubstitute {
    private static final char ESCAPE_CHAR = '\\';

    private static String substitute(String str, String schStr, String repStr) {
        StringBuffer retStrBuf = new StringBuffer();
        if (str == null || schStr == null || repStr == null) {
            retStrBuf = null;
        } else {
            schStr = "%" + schStr + "%";
            int sLen = schStr.length();
            int fromIndex = 0;
            int startIndex = str.indexOf(schStr, fromIndex);
            while (startIndex != -1) {
                if (startIndex != 0 && str.charAt(startIndex - 1) == '\\') {
                    retStrBuf.append(str.substring(fromIndex, startIndex - 1)).append(str.substring(startIndex, startIndex + sLen));
                    fromIndex = startIndex + sLen;
                    startIndex = str.indexOf(schStr, fromIndex);
                    continue;
                }
                retStrBuf.append(str.substring(fromIndex, startIndex)).append(repStr);
                fromIndex = startIndex + sLen;
                startIndex = str.indexOf(schStr, fromIndex);
            }
            retStrBuf.append(str.substring(fromIndex));
        }
        if (retStrBuf == null) {
            return null;
        }
        return retStrBuf.toString();
    }

    public static Vector substitute(Vector<String> ldifEntry, Vector sAndRep, boolean isUtf) {
        Vector<String> retVect;
        int ldifEntrySz = 0;
        int sAndRepSz = 0;
        if (ldifEntry == null || (ldifEntrySz = ldifEntry.size()) == 0) {
            retVect = null;
        } else if (sAndRep == null || (sAndRepSz = sAndRep.size()) == 0) {
            retVect = ldifEntry;
        } else {
            retVect = new Vector();
            for (int iCn = 0; iCn < ldifEntrySz; ++iCn) {
                boolean base64Encoded = false;
                String tmpStr = ldifEntry.elementAt(iCn);
                int startIndex = tmpStr.indexOf("::");
                if (startIndex != -1) {
                    tmpStr = tmpStr.substring(0, startIndex + 2) + (isUtf ? Base64.utfDecode(tmpStr.substring(startIndex + 2)) : new String(Base64.decode(tmpStr.substring(startIndex + 2).getBytes())));
                    base64Encoded = true;
                }
                String atrStr = tmpStr;
                for (int jCn = 0; jCn < sAndRepSz - 1; jCn += 2) {
                    String schStr = (String)sAndRep.elementAt(jCn);
                    String repStr = (String)sAndRep.elementAt(jCn + 1);
                    atrStr = LDIFSubstitute.substitute(atrStr, schStr, repStr);
                }
                if (atrStr == null) continue;
                if (base64Encoded) {
                    startIndex = atrStr.indexOf("::");
                    atrStr = atrStr.substring(0, startIndex + 2) + (isUtf ? Base64.utfEncode(atrStr.substring(startIndex + 2)) : new String(Base64.encode(atrStr.substring(startIndex + 2).getBytes())));
                }
                retVect.addElement(atrStr);
            }
        }
        return retVect;
    }

    public static Vector substitute(Vector<String> ldifEntry, Vector sAndRep) {
        return LDIFSubstitute.substitute(ldifEntry, sAndRep, false);
    }

    public static void main(String[] args) {
        String rep = "s_var";
        String str = "%s_var%,dn: cn=Heman,%s_var%s_var%,dc=ORACLE,dc_COM%s_var%%s_var%";
        String repWith = "dc=IDC";
        System.out.println(str);
        System.out.println(LDIFSubstitute.substitute(str, rep, repWith));
    }
}

