/*
 * Decompiled with CFR 0.152.
 */
package oracle.jldif.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import oracle.jldif.util.LDIFReader;
import oracle.jldif.util.LDIFRecord;
import oracle.jldif.util.LDIFSubstitute;
import oracle.jldif.util.LDIFWriter;
import oracle.jldif.util.UtilException;
import oracle.jldif.util.XLIFFParser;

public class LDIFLoader {
    private static String fileName = null;
    private static Vector subVector = null;
    private boolean debug = true;
    private DirContext ctx = null;
    private boolean ignoreError = false;
    private NamingException[] ignoredExceptionList = null;
    private PrintStream pStream = null;
    private String listFileExt = ".lst";
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");

    public LDIFLoader(DirContext inCtx, String inFileName, Vector inSubVector, Logger lgr) {
        this(inCtx, inFileName, inSubVector);
        m_logger = lgr;
    }

    public LDIFLoader(DirContext inCtx, String inFileName, Vector inSubVector) {
        fileName = inFileName;
        subVector = inSubVector;
        if (inCtx == null || inFileName == null) {
            // empty if block
        }
        this.ctx = inCtx;
        this.debug = false;
        this.pStream = System.out;
    }

    public void load() throws UtilException {
        if (fileName.endsWith(this.listFileExt)) {
            this.recursiveLoad(fileName, "");
        } else if (fileName.endsWith(".xlf")) {
            this.loadXLFFile(fileName);
        } else {
            this.loadOneLdifFile(fileName, "");
        }
    }

    public void load(boolean ignoreError, PrintStream pStream) throws UtilException {
        this.pStream = pStream == null ? System.out : pStream;
        this.ignoreError = ignoreError;
        this.load();
    }

    private void recursiveLoad(String inFileName, String indentStr) throws UtilException {
        try {
            File file = new File(inFileName);
            if (!file.exists()) {
                // empty if block
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            String directory = file.getParent();
            while (in.ready()) {
                String curLine = in.readLine().trim();
                if (curLine.length() <= 0 || curLine.startsWith("#")) continue;
                String curFile = directory + File.separator + curLine;
                if (curFile.endsWith(this.listFileExt)) {
                    this.recursiveLoad(curFile, indentStr + "   ");
                    continue;
                }
                this.loadOneLdifFile(curFile, indentStr + "   ");
            }
        }
        catch (Exception e) {
            System.out.println("Error loading the file");
        }
    }

    private void loadOneLdifFile(String curFileName, String indentStr) throws UtilException {
        try {
            System.out.println("Loading LDIF File: " + curFileName);
            LDIFReader ldifReader = new LDIFReader(curFileName);
            LDIFWriter ldifWriter = null;
            ByteArrayOutputStream outStream = null;
            outStream = new ByteArrayOutputStream();
            ldifWriter = new LDIFWriter(outStream);
            Vector<String> ldifEntry = null;
            Vector subsLdifEntry = null;
            while ((ldifEntry = ldifReader.nextEntry()) != null) {
                subsLdifEntry = LDIFSubstitute.substitute(ldifEntry, subVector);
                ldifWriter.writeEntry(subsLdifEntry);
            }
            ldifWriter.close();
            ldifReader.close();
            ldifReader = new LDIFReader(new ByteArrayInputStream(outStream.toByteArray()), "UTF-8");
            LDIFRecord curRecord = null;
            while ((curRecord = ldifReader.nextRecord()) != null) {
                this.loadRecord(curRecord);
            }
            ldifReader.close();
        }
        catch (IOException e) {
            System.out.println("IOException encountered when loading file : " + curFileName);
            System.exit(1);
        }
    }

    private void loadXLFFile(String fileName) {
        try {
            System.out.println("Loading XLIFF File: " + fileName);
            XLIFFParser parser = new XLIFFParser();
            Vector<LDIFRecord> ldifRecords = parser.parseXLFFile(fileName);
            for (LDIFRecord rec : ldifRecords) {
                this.loadRecord(rec);
            }
        }
        catch (Exception e) {
            System.out.println("Error:" + e);
        }
    }

    private void loadRecord(LDIFRecord curRecord) throws UtilException {
        try {
            switch (curRecord.getChangeType()) {
                case 1: {
                    Attributes attrs = curRecord.getJNDIAttributes();
                    this.ctx.createSubcontext(curRecord.getDN(), attrs);
                    break;
                }
                case 3: {
                    ModificationItem[] modItem = curRecord.getJNDIModificationItems();
                    this.ctx.modifyAttributes(curRecord.getDN(), modItem);
                    break;
                }
                case 2: {
                    this.ctx.destroySubcontext(curRecord.getDN());
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                m_logger.log(Level.INFO, "Unable to establish connection to directory. Verify the input parameters: host, port, dn & password");
            }
            if (this.ignoreError) {
                if (!this.isIgnoredException(e)) {
                    throw new UtilException("\nNamingException encountered during loading of record:  " + curRecord.toString(), e);
                }
                System.out.println("Ignoring Error " + e);
            }
            throw new UtilException("\nNamingException encountered during loading of record:  " + curRecord.toString(), e);
        }
    }

    private boolean isIgnoredException(Exception ne) {
        if (this.ignoredExceptionList == null) {
            return true;
        }
        return ne instanceof AttributeInUseException || ne instanceof NameAlreadyBoundException || ne instanceof NoSuchAttributeException;
    }
}

