/*
 * Decompiled with CFR 0.152.
 */
package oracle.jldif.util;

import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import oracle.jldif.util.ConnectionUtil;
import oracle.jldif.util.LDIFLoader;
import oracle.jldif.util.UtilException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LDIFLoadTool
extends Task {
    private String m_property;
    private String m_host;
    private String m_bindDN;
    private String m_password;
    private String m_file;
    private int m_port;
    private boolean m_ignoreError = true;
    private boolean isSSL = true;

    public void setSSL(boolean enableSSL) {
        this.isSSL = enableSSL;
    }

    public void setProperty(String inProperty) {
        this.m_property = inProperty;
    }

    public void setHost(String inHost) {
        this.m_host = inHost;
    }

    public void setPort(int inPort) {
        this.m_port = inPort;
    }

    public void setBindDN(String inBindDN) {
        this.m_bindDN = inBindDN;
    }

    public void setPwd(String inPwd) {
        this.m_password = inPwd;
    }

    public void setFile(String inFile) {
        this.m_file = inFile;
    }

    public void setIgnoreError(boolean ignoreError) {
        this.m_ignoreError = ignoreError;
    }

    public void execute() throws BuildException {
        if (this.m_property == null) {
            throw new BuildException("Error: No property name");
        }
        if (this.m_host == null) {
            throw new BuildException("Error: No Host Name");
        }
        if (this.m_port == 0) {
            throw new BuildException("Error: No Port Number");
        }
        if (this.m_bindDN == null) {
            throw new BuildException("Error: No bind DN");
        }
        if (this.m_password == null) {
            throw new BuildException("Error: No bind Password");
        }
        if (this.m_file == null) {
            throw new BuildException("Error: No LDIF/XLIFF File Specified");
        }
        String retVal = null;
        try {
            this.loadLdifFile(this.m_host, this.m_port, this.m_bindDN, this.m_password, this.m_file, this.m_ignoreError);
            retVal = "Loading Process Completed";
        }
        catch (NamingException ne) {
            retVal = "Connect details not specified Correctly.";
            throw new BuildException(retVal + ne.getMessage());
        }
        catch (UtilException ue) {
            retVal = "Error Loading the LDIF File";
            throw new BuildException(retVal + ue.getMessage());
        }
        finally {
            if (retVal != null) {
                this.getProject().setNewProperty(this.m_property, retVal);
            }
        }
    }

    public void loadLdifFile(String host, int port, String bindDN, String password, String file, boolean ignoreError) throws NamingException, UtilException {
        this.loadLdifFile(host, port, bindDN, password, file, ignoreError, this.isSSL);
    }

    public void loadLdifFile(String host, int port, String bindDN, String password, String file, boolean ignoreError, boolean enableSSL) throws NamingException, UtilException {
        InitialLdapContext ctx = null;
        ctx = enableSSL ? ConnectionUtil.getSSLDirCtx(host, Integer.toString(port), bindDN, password) : ConnectionUtil.getNonSSLDirCtx(host, Integer.toString(port), bindDN, password);
        LDIFLoader ldif = new LDIFLoader(ctx, file, null);
        ldif.load(ignoreError, null);
        if (ctx != null) {
            ctx.close();
        }
    }
}

