/*
 * Decompiled with CFR 0.152.
 */
package oracle.jldif.util;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;

public final class EnterpriseID
implements Cloneable {
    private static final long TIME_OFFSET = 1270164433755L;
    private static final long TIME_RANGE = 0x10000000000L;
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA-1";
    private static final int NODE_ADDRESS_SIZE_IN_BYTES = 2;
    private static final int TIME_COMPONENT_SIZE_IN_BYTES = 5;
    private static final int ENTERPRISE_ID_SIZE_IN_BYTES = 7;
    private static final int ENT_ID_OUT_SIZE_IN_BYTES = 8;
    private long lastSystemTime;
    private BigInteger timeRange = new BigInteger(Long.toString(0x10000000000L));
    private byte[] nodeID = EnterpriseID.getNodeIDComponent();
    private static EnterpriseID tenantIDGenerator = new EnterpriseID();

    static EnterpriseID getInstance() {
        return tenantIDGenerator;
    }

    public Long generateEnterpriseID() {
        long tenantID = 0L;
        while (tenantID < 11L) {
            byte[] enterpriseID = new byte[8];
            byte[] tc = this.getTimeComponent();
            System.arraycopy(this.nodeID, 0, enterpriseID, 1, 2);
            System.arraycopy(tc, 0, enterpriseID, 3, 5);
            ByteBuffer bb = ByteBuffer.wrap(enterpriseID);
            tenantID = bb.getLong();
        }
        return new Long(tenantID);
    }

    private static byte[] getNodeIDComponent() {
        byte[] hash = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
            InetAddress nodeAddress = InetAddress.getLocalHost();
            if (!nodeAddress.isLoopbackAddress()) {
                messageDigest.update(nodeAddress.getCanonicalHostName().getBytes());
                messageDigest.update(nodeAddress.getAddress());
            }
            Collection<Object> systemValues = System.getProperties().values();
            Iterator<Object> systemValuesIter = systemValues.iterator();
            while (systemValuesIter.hasNext()) {
                messageDigest.update(((String)systemValuesIter.next()).getBytes());
            }
            hash = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        byte[] nodeID = new byte[2];
        System.arraycopy(hash, 0, nodeID, 0, 2);
        return nodeID;
    }

    private byte[] getTimeComponent() {
        long ticks = this.getTimeOffset();
        BigInteger bTicks = new BigInteger(Long.toString(ticks -= 1270164433755L));
        bTicks = bTicks.mod(this.timeRange);
        byte[] hash1 = bTicks.toByteArray();
        byte[] hash2 = new byte[5];
        System.arraycopy(hash1, 0, hash2, 5 - hash1.length, hash1.length);
        return hash2;
    }

    private synchronized long getTimeOffset() {
        long currentSystemTime = System.currentTimeMillis();
        while (currentSystemTime == this.lastSystemTime) {
            try {
                Thread.currentThread();
                Thread.sleep(1L);
                currentSystemTime = System.currentTimeMillis();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lastSystemTime = currentSystemTime;
        return currentSystemTime;
    }

    public static void main(String[] args) {
        EnterpriseID tidg = new EnterpriseID();
        System.out.println(tidg.generateEnterpriseID());
    }
}

